<?php
// get_classes.php
// Fetches a list of class names from the 'classes' table.
require_once 'db_connect.php'; // Include the database connection file
if ($_SERVER['REQUEST_METHOD'] == 'GET') {
    // Prepare a SQL statement to select all class names
    $stmt = $conn->prepare("SELECT class_name FROM classes ORDER BY id ASC");
    $stmt->execute(); // Execute the statement
    $result = $stmt->get_result(); // Get the result set

    $classes = []; // Initialize an empty array to hold class names
    // Fetch all rows and add them to the classes array
    while ($row = $result->fetch_assoc()) {
        $classes[] = $row['class_name']; // Add only the class_name to the array
    }
    // Return success status and the fetched data as a JSON array
    echo json_encode(['status' => 'success', 'data' => $classes]);

    $stmt->close(); // Close the statement
} else {
    // If request method is not GET, return an error
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method.']);
}
$conn->close(); // Close the database connection
?>