<?php
// get_floors_by_hostel.php - Fetches floors for a given hostel_id

// Enable full error reporting for debugging. REMOVE IN PRODUCTION!
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'config.php';
header('Content-Type: application/json');

if (isset($_GET['hostel_id']) && !empty($_GET['hostel_id'])) {
    $hostelId = filter_var($_GET['hostel_id'], FILTER_SANITIZE_NUMBER_INT);

    if ($hostelId === false) {
        echo json_encode(['success' => false, 'message' => 'Invalid hostel ID.']);
        exit;
    }

    $sql = "SELECT floor_id, floor_number, description FROM floors WHERE hostel_id = :hostel_id ORDER BY floor_number ASC";

    try {
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':hostel_id', $hostelId, PDO::PARAM_INT);
        $stmt->execute();
        $floors = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($floors) {
            echo json_encode(['success' => true, 'floors' => $floors]);
        } else {
            echo json_encode(['success' => true, 'message' => 'No floors found for this hostel.', 'floors' => []]);
        }
    } catch (PDOException $e) {
        error_log("Database error in get_floors_by_hostel.php: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'A database error occurred while fetching floors.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Hostel ID not provided.']);
}

