<?php
require_once 'db.php';

$class = $_GET['class_grade'] ?? '';

if ($class) {
    $sql = "SELECT unique_reg_number, full_name 
            FROM students 
            WHERE class_grade = ? 
            AND unique_reg_number NOT IN (
                SELECT unique_reg_number 
                FROM student_assignments 
                WHERE status = 'assigned'
            )
            ORDER BY full_name ASC";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $class);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($res->num_rows > 0) {
        echo "<option value=''>Choose Student...</option>";
        while ($row = $res->fetch_assoc()) {
            echo "<option value='{$row['unique_reg_number']}'>".htmlspecialchars($row['full_name'])." ({$row['unique_reg_number']})</option>";
        }
    } else {
        echo "<option value=''>No available students</option>";
    }
    $stmt->close();
} else {
    echo "<option value=''>Invalid request</option>";
}
