<?php
session_start();
require_once 'db.php';
header("Content-Type: application/json; charset=UTF-8");
// Send errors to log, not browser
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php_error.log');

require_once 'config.php'; // Must define $conn (MySQLi)

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Invalid request method']);
    exit;
}

$fullName        = $_POST['fullName'] ?? '';
$classGrade      = $_POST['classGrade'] ?? '';
$section         = $_POST['section'] ?? '';
$admissionNumber = $_POST['admissionNumber'] ?? '';
$dob             = $_POST['dob'] ?? '';
$gender          = $_POST['gender'] ?? '';
$bloodGroup      = $_POST['bloodGroup'] ?? '';
$religion        = $_POST['religion'] ?? '';
$category        = $_POST['category'] ?? '';
$aadharNumber    = $_POST['aadharNumber'] ?? '';

if (!$fullName || !$classGrade || !$admissionNumber || !$dob || !$gender || !$category) {
    echo json_encode(['status' => 'error', 'message' => 'Missing required fields']);
    exit;
}

$uniqueId = 'STU-' . time() . strtoupper(substr(uniqid(), -4));

$stmt = $conn->prepare("
    INSERT INTO students 
    (full_name, class_grade, section, admission_number, dob, gender, blood_group, religion, category, aadhar_number, unique_reg_number)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
");

if (!$stmt) {
    error_log("Prepare failed: " . $conn->error);
    echo json_encode(['status' => 'error', 'message' => 'Database error: prepare failed']);
    exit;
}

$stmt->bind_param(
    "sssssssssss",
    $fullName,
    $classGrade,
    $section,
    $admissionNumber,
    $dob,
    $gender,
    $bloodGroup,
    $religion,
    $category,
    $aadharNumber,
    $uniqueId
);

if ($stmt->execute()) {
    echo json_encode(['status' => 'success', 'uniqueId' => $uniqueId]);
} else {
    error_log("Execute failed: " . $stmt->error);
    echo json_encode(['status' => 'error', 'message' => 'Database error: execute failed']);
}

$stmt->close();
$conn->close();
