<?php
// student_registration_step5.php
session_start();

// Auth check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

$pageTitle = 'Floors Registration - Step 5';
require_once 'config.php';
include_once '_header.php';
include_once '_sidebar.php';
?>
<main class="container-fluid" id="appContent">
    <h1 class="mb-4">Student Registration - Step 5</h1>

    <div class="form-header">
        <h2>School Hostel Registration</h2>
        <p class="text-muted">Hostel Preferences</p>
    </div>

    <!-- Step Indicator -->
    <div class="step-indicator mb-4">
        <div class="step"><div class="step-circle">1</div><div class="step-label">Student Info</div></div>
        <div class="step"><div class="step-circle">2</div><div class="step-label">Parent Details</div></div>
        <div class="step"><div class="step-circle">3</div><div class="step-label">Address</div></div>
        <div class="step"><div class="step-circle">4</div><div class="step-label">Emergency Contact</div></div>
        <div class="step active" id="step5">
            <div class="step-circle">5</div>
            <div class="step-label">Hostel Preferences</div>
        </div>
        <div class="step"><div class="step-circle">6</div><div class="step-label">Documents</div></div>
    </div>

    <!-- Hostel Preferences Form -->
    <form id="hostelPreferencesForm">
        <input type="hidden" name="uniqueId" id="uniqueId">

        <div class="row g-3 mb-4">
            <div class="col-md-6">
                <label for="preferredRoomType" class="form-label">Preferred Room Type</label>
                <select class="form-select" id="preferredRoomType" name="preferredRoomType">
                    <option value="">-- Select --</option>
                    <option value="Single">Single</option>
                    <option value="Shared">Shared</option>
                    <option value="Dormitory">Dormitory</option>
                </select>
            </div>
            <div class="col-md-12">
                <label for="medicalConditionAllergy" class="form-label">Medical Condition / Allergy</label>
                <textarea class="form-control" id="medicalConditionAllergy" name="medicalConditionAllergy"></textarea>
            </div>
            <div class="col-md-12">
                <label for="specialRequirements" class="form-label">Special Requirements</label>
                <textarea class="form-control" id="specialRequirements" name="specialRequirements"></textarea>
            </div>
        </div>

        <button type="submit" class="btn btn-primary">Save & Continue</button>
    </form>

    <div id="result" class="mt-3"></div>
</main>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    const urlParams = new URLSearchParams(window.location.search);
    const regId = urlParams.get('reg');
    if (regId) {
        $('#uniqueId').val(regId);
    }

    $("#hostelPreferencesForm").on("submit", function(e) {
        e.preventDefault();
        $.ajax({
            url: "student_registration_step5_action.php",
            type: "POST",
            data: $(this).serialize(),
            dataType: "json",
            success: function(data) {
                if (data.status === "success") {
                    $("#result").html('<div class="alert alert-success">'+data.message+'</div>');
                    window.location.href = 'student_registration_step6.php?reg=' + encodeURIComponent(data.uniqueId);
                } else {
                    $("#result").html('<div class="alert alert-danger">'+data.message+'</div>');
                }
            },
            error: function() {
                $("#result").html('<div class="alert alert-danger">An unexpected error occurred</div>');
            }
        });
    });
});
</script>
<?php include_once 'footer.php'; ?>
