<?php
session_start();
require_once 'db.php';

// Auth check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

if (!isset($_GET['reg']) || empty($_GET['reg'])) {
    die("Invalid request");
}

$regNo = $_GET['reg'];

// Fetch student details with hostel assignment
$sql = "SELECT s.*, 
               h.name AS hostel_name, 
               f.floor_number, 
               r.room_number, 
               b.bed_number
        FROM students s
        LEFT JOIN student_assignments sa 
            ON s.unique_reg_number = sa.unique_reg_number AND sa.status = 'assigned'
        LEFT JOIN beds b ON sa.bed_id = b.bed_id
        LEFT JOIN rooms r ON b.room_id = r.room_id
        LEFT JOIN floors f ON r.floor_id = f.floor_id
        LEFT JOIN hostels h ON f.hostel_id = h.hostel_id
        WHERE s.unique_reg_number = ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $regNo);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows === 0) {
    die("Student not found");
}
$student = $result->fetch_assoc();
$stmt->close();

$pageTitle = "View Profile - " . htmlspecialchars($student['full_name']);
include_once '_header.php';
include_once '_sidebar.php';
?>
<main class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="mb-0">Student Profile</h1>
    </div>

    <div class="card shadow-sm p-3">
        <div class="row">
            <div class="col-md-3 text-center">
                <?php if (!empty($student['photo_path'])): ?>
                    <img src="<?php echo htmlspecialchars($student['photo_path']); ?>" 
                         class="img-fluid rounded border" style="max-width:200px;">
                <?php else: ?>
                    <div class="text-muted">No Photo</div>
                <?php endif; ?>
            </div>
            <div class="col-md-9">
                <h4><?php echo htmlspecialchars($student['full_name']); ?></h4>
                <p><strong>Status:</strong> 
                    <?php echo $student['status'] == 'active' 
                        ? '<span class="badge bg-success">Active</span>' 
                        : '<span class="badge bg-secondary">Inactive</span>'; ?>
                </p>
                <p><strong>Reg No:</strong> <?php echo htmlspecialchars($student['unique_reg_number']); ?></p>
                <p><strong>Class/Grade:</strong> <?php echo htmlspecialchars($student['class_grade']); ?> 
                   <strong>Section:</strong> <?php echo htmlspecialchars($student['section']); ?></p>
                <p><strong>Admission No:</strong> <?php echo htmlspecialchars($student['admission_number']); ?></p>
                <p><strong>DOB:</strong> <?php echo htmlspecialchars($student['dob']); ?> 
                   <strong>Gender:</strong> <?php echo htmlspecialchars($student['gender']); ?></p>
                <p><strong>Aadhar No:</strong> <?php echo htmlspecialchars($student['aadhar_number']); ?></p>
                <p><strong>Father's Name:</strong> <?php echo htmlspecialchars($student['father_name']); ?> 
                   <strong>Mobile:</strong> <?php echo htmlspecialchars($student['father_guardian_mobile']); ?></p>
                <p><strong>Mother's Name:</strong> <?php echo htmlspecialchars($student['mother_name']); ?> 
                   <strong>Mobile:</strong> <?php echo htmlspecialchars($student['mother_mobile']); ?></p>
                <p><strong>Email:</strong> <?php echo htmlspecialchars($student['email_id']); ?></p>
                <hr>
                <p><strong>Permanent Address:</strong> <?php echo htmlspecialchars($student['permanent_address']); ?></p>
                <p><strong>Correspondence Address:</strong> <?php echo htmlspecialchars($student['correspondence_address']); ?></p>
                <p><strong>District:</strong> <?php echo htmlspecialchars($student['district']); ?> 
                   <strong>State:</strong> <?php echo htmlspecialchars($student['state']); ?> 
                   <strong>Pincode:</strong> <?php echo htmlspecialchars($student['pincode']); ?></p>
                <hr>
                <p><strong>Emergency Contact:</strong> <?php echo htmlspecialchars($student['emergency_contact_name']); ?> 
                   (<?php echo htmlspecialchars($student['emergency_relation']); ?>) - 
                   <?php echo htmlspecialchars($student['emergency_mobile']); ?></p>
                <p><strong>Alternate Number:</strong> <?php echo htmlspecialchars($student['emergency_alternate_number']); ?></p>
                <hr>
                <p><strong>Preferred Room:</strong> <?php echo htmlspecialchars($student['preferred_room_type']); ?></p>
                <p><strong>Medical Condition / Allergy:</strong> <?php echo htmlspecialchars($student['medical_condition_allergy']); ?></p>
                <p><strong>Special Requirements:</strong> <?php echo htmlspecialchars($student['special_requirements']); ?></p>
                
                <!-- Hostel Assignment Details -->
                <hr>
                <h5>Hostel Details</h5>
                <p><strong>Hostel:</strong> <?php echo $student['hostel_name'] ?? '<span class="text-danger">Not Assigned</span>'; ?></p>
                <p><strong>Floor:</strong> <?php echo $student['floor_number'] ?? 'N/A'; ?></p>
                <p><strong>Room:</strong> <?php echo $student['room_number'] ?? 'N/A'; ?></p>
                <p><strong>Bed:</strong> <?php echo $student['bed_number'] ?? 'N/A'; ?></p>

                <?php if (!empty($student['aadhar_card_path'])): ?>
                    <hr>
                    <p><strong>Aadhar Card:</strong></p>
                    <a href="<?php echo htmlspecialchars($student['aadhar_card_path']); ?>" target="_blank" class="btn btn-secondary btn-sm">Download</a>
                <?php endif; ?>

                <?php if (!empty($student['unique_reg_number'])): ?>
                    <hr>
                    <a href="edit_student.php?reg=<?php echo urlencode($student['unique_reg_number']); ?>" 
                       class="btn btn-secondary btn-sm">Edit Profile</a>
                <?php endif; ?>

                <div>
                    <hr>
                    <!-- Activate / Deactivate -->
                    <?php if ($student['status'] == 'active'): ?>
                        <a href="toggle_student_status.php?reg=<?php echo urlencode($student['unique_reg_number']); ?>&status=inactive" 
                           class="btn btn-warning btn-sm">Deactivate</a>
                    <?php else: ?>
                        <a href="toggle_student_status.php?reg=<?php echo urlencode($student['unique_reg_number']); ?>&status=active" 
                           class="btn btn-success btn-sm">Activate</a>
                    <?php endif; ?>
                    <hr>
                    <button onclick="window.print();" class="btn btn-secondary btn-sm">Print Profile</button>
                </div>

            </div>
        </div>
    </div>
</main>
<?php include_once 'footer.php'; ?>
