<?php
if (session_status() == PHP_SESSION_NONE) {
session_start();
}
// Default title if not set by the page including this file
$pageTitle = $pageTitle ?? 'Hostel Management System';
// Get admin details from session for display in header (if logged in)
$admin_username = $_SESSION['username'] ?? '';
$admin_full_name = $_SESSION['full_name'] ?? 'Guest';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle); ?></title>
    <!-- Bootstrap CSS for styling and responsiveness -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome for icons (like the hamburger menu, hotel icon, etc.) -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
      <link rel="icon" type="image/png"  href="./img/logo.png">
   
   
   <style>
        /* Define CSS variables for consistent theming */
        :root {
            --primary-color: #007bff;
            --secondary-color: #6c757d;
            --success-color: #28a745;
            --danger-color: #dc3545;
            --info-color: #17a2b8;
            --warning-color: #ffc107;
            --light-color: #f8f9fa;
            --dark-color: #343a40;
            --sidebar-width: 250px; /* Width of the sidebar */
            --header-height: 60px;  /* Height of the fixed header */
            --footer-height: 50px;  /* Height of the fixed footer */
        }

        /* Basic body styling for full height layout */
        body {
            font-family: 'Inter', sans-serif; /* Preferred font */
            background-color: var(--light-color);
            margin: 0;
            display: flex;
            flex-direction: column; /* Arranges children (header, main content, footer) vertically */
            min-height: 100vh; /* Ensures body takes at least full viewport height */
            padding-top: var(--header-height);    /* Space for the fixed header */
            padding-bottom: var(--footer-height); /* Space for the fixed footer */
        }

        /* Header Styling */
        .app-header {
            background-color: var(--dark-color);
            color: white;
            height: var(--header-height);
            display: flex;
            align-items: center; /* Vertically center items */
            padding: 0 15px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1); /* Subtle shadow */
            position: fixed; /* Makes header stick to the top */
            width: 100%;
            top: 0;
            left: 0;
            z-index: 1030; /* Ensures header is above other content */
        }

        .app-header .navbar-brand {
            color: white;
            font-weight: bold;
            font-size: 1.5rem;
            text-decoration: none;
            /* For non-admin pages, this will be centered via mx-auto class */
        }

        .app-header .navbar-brand:hover {
            color: #e9ecef; /* Lighter color on hover */
        }

        /* Sidebar Toggle Button Styling */
        .sidebar-toggler {
            background: none;
            border: none;
            color: white;
            font-size: 1.5rem;
            cursor: pointer;
            padding: 0 10px;
            transition: transform 0.3s ease; /* Smooth transition for icon */
        }

        /* Sidebar Styling (Default hidden) */
        .app-sidebar {
            width: var(--sidebar-width);
            background-color: var(--dark-color);
            color: white;
            position: fixed; /* Fixed position relative to viewport */
            top: var(--header-height); /* Starts below the header */
            left: 0;
            /* Calculates height to fill space between header and footer */
            height: calc(100% - var(--header-height) - var(--footer-height));
            overflow-y: auto; /* Enables scrolling if content overflows */
            transition: transform 0.3s ease; /* Smooth slide-in/out effect */
            /* Default state: hidden on all screens by sliding it left by its own width */
            transform: translateX(-var(--sidebar-width));
            z-index: 1020; /* Below header, above main content */
            box-shadow: 2px 0 5px rgba(0, 0, 0, 0.1); /* Subtle shadow */
            padding-top: 20px;
        }

        /* Class added by JavaScript when sidebar should be visible */
        .app-sidebar.sidebar-open {
            transform: translateX(0); /* Moves sidebar into view */
        }

        .app-sidebar .nav-link {
            color: #adb5bd; /* Default link color */
            padding: 12px 20px;
            display: flex;
            align-items: center;
            border-radius: 0.5rem;
            margin: 5px 10px;
            transition: background-color 0.2s ease, color 0.2s ease;
        }

        .app-sidebar .nav-link:hover,
        .app-sidebar .nav-link.active {
            background-color: var(--primary-color); /* Highlight on hover/active */
            color: white;
        }

        .app-sidebar .nav-link i {
            margin-right: 10px;
            font-size: 1.1rem;
        }

        /* Main Content Wrapper Styling */
        /* This div wraps the entire content area that should be affected by the sidebar */
        .main-content-wrapper {
            flex-grow: 1; /* Allows this area to take up remaining vertical space */
            padding: 20px; /* General padding around content */
            margin-left: 0; /* Default: content takes full width, no initial shift */
            transition: margin-left 0.3s ease; /* Smooth transition for content shift */
        }

        /* Class added by JavaScript when sidebar is open to shift content */
        .main-content-wrapper.sidebar-open-margin {
            margin-left: var(--sidebar-width); /* Shifts content to the right to make space for sidebar */
        }
        /* Styles for form containers (used on login, register, student forms) */
        .form-container {
            background-color: #ffffff;
            border-radius: 1rem;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
            padding: 40px;
            width: 100%;
            max-width: 450px; /* Default max-width for login/register forms */
            text-align: center; /* Centers content inside the form container */
        }
        .form-container.wide { /* For wider forms like student registration */
            max-width: 800px;
            text-align: left; /* Align text left for multi-column forms */
        }
        .form-header {
            margin-bottom: 30px;
        }
        .form-header h2 {
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 10px;
        }
        /* General form control styling */
        .form-control, .form-select {
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
            border: 1px solid #ced4da;
            transition: border-color 0.2s ease, box-shadow 0.2s ease;
        }
        .form-control:focus, .form-select:focus {
            border-color: #80bdff;
            box-shadow: 0 0 0 0.25rem rgba(0, 123, 255, 0.25);
        }
        /* Primary button styling */
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            padding: 10px 25px;
            font-size: 1.1rem;
            border-radius: 0.75rem;
            width: 100%; /* Default for login/register buttons */
            transition: background-color 0.2s ease, border-color 0.2s ease, transform 0.2s ease;
        }
        .btn-primary:hover {
            background-color: #0056b3;
            border-color: #0056b3;
            transform: translateY(-2px); /* Slight lift effect */
        }
        /* Form text links */
        .form-text a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
        }
        .form-text a:hover {
            text-decoration: underline;
        }

        /* Alert message styling */
        .alert-message {
            margin-top: 20px;
            padding: 10px 15px;
            border-radius: 0.5rem;
            font-size: 0.95rem;
            display: none; /* Hidden by default, shown by JS */
        }

        /* Footer Styling */
        .app-footer {
            background-color: var(--dark-color);
            color: white;
            height: var(--footer-height);
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 15px;
            text-align: center;
            box-shadow: 0 -2px 4px rgba(0, 0, 0, 0.1);
            position: fixed; /* Makes footer stick to the bottom */
            width: 100%;
            bottom: 0;
            left: 0;
            z-index: 1030;
        }
        /* Responsive adjustments for screens up to 768px wide (mobile/tablet) */
        @media (max-width: 768px) {
            /* Sidebar is already hidden by default with transform: translateX(-var(--sidebar-width)); */
            /* The .sidebar-open class will bring it into view */

            /* Main content wrapper on mobile always starts with margin-left: 0; */
            /* The .sidebar-open-margin class will shift it when sidebar is open */
            .main-content-wrapper {
                margin-left: 0;
                padding: 15px; /* Adjust padding for smaller screens */
            }
            /* Show sidebar toggler on mobile */
            .sidebar-toggler {
                display: block;
            }
            /* Adjust form padding for smaller screens */
            .form-container {
                padding: 30px;
            }
        }
@media print {
    body * {
        visibility: hidden;
    }
    main, main * {
        visibility: visible;
    }
    main {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
    }
    .btn, .btn-group {
        display: none !important;
    }
}
</style>
</head>
<body>
    <!-- Header -->
    <header class="app-header">
        <?php
        // PHP logic to determine if the current page is an admin dashboard page
        // This controls the visibility of the sidebar toggle and admin specific header elements
        $isAdminPage = (
            strpos($pageTitle, 'Admin Dashboard') !== false ||
            strpos($pageTitle, 'Hostels') !== false ||
            strpos($pageTitle, 'Floors') !== false ||
            strpos($pageTitle, 'Students') !== false ||
            strpos($pageTitle, 'View') !== false ||
            strpos($pageTitle, 'Rooms & Beds') !== false ||
            strpos($pageTitle, 'Assignments') !== false ||
            strpos($pageTitle, 'Reports') !== false ||
            strpos($pageTitle, 'Outpass') !== false ||
            strpos($pageTitle, 'MakeGatePass') !== false ||
            strpos($pageTitle, 'GatePass') !== false ||
            strpos($pageTitle, 'Generated') !== false ||
            strpos($pageTitle, 'Logout') !== false
        );
        ?>
        <?php if ($isAdminPage) { ?>
            <!-- Sidebar toggle button, only visible on admin pages -->
            <button class="sidebar-toggler" id="sidebarToggle">
                <i class="fas fa-bars"></i>
            </button>
        <?php } ?>
        <!-- Application logo/brand -->
        <a class="navbar-brand <?php echo $isAdminPage ? '' : 'mx-auto'; ?>" href="#">
        </a>
        <?php if ($isAdminPage && isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) { ?>
            <!-- Admin welcome message and logout button, only on logged-in admin pages -->
            <div class="ms-auto">
                <span class="me-3"><?php echo htmlspecialchars($admin_full_name); ?>!</span>
                <a href="logout.php" class="btn btn-outline-light btn-sm rounded-pill">Logout</a>
            </div>
        <?php } ?>
    </header>
    <!-- This div wraps the main content of each page. Its margin will be adjusted by JS for sidebar. -->
    <div class="main-content-wrapper <?php echo $isAdminPage ? 'd-flex flex-column' : 'd-flex justify-content-center align-items-center'; ?>" id="mainContentWrapper">
    <!-- Content for individual pages will be inserted here -->
