<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}
$pageTitle = 'MakeGatePass';
require_once 'config.php'; // (must NOT echo anything)
include_once '_header.php';
include_once '_sidebar.php';
?>
<div class="container vh-100 d-flex align-items-center justify-content-center">
  <div class="card shadow-lg p-4" style="width: 100%; max-width: 500px;">
    <h4 class="text-center mb-3">Visitor Gate Enquiry</h4>
    <form id="gateForm" enctype="multipart/form-data">
      <div class="mb-3">
        <label class="form-label">Full Name</label>
        <input type="text" class="form-control" name="visitor_name" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Purpose</label>
        <input type="text" class="form-control" name="purpose" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Mobile Number</label>
        <input type="text" class="form-control" name="mobile" maxlength="10" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Capture Photo</label>
        <input type="file" class="form-control" name="photo" accept="image/*" capture="camera" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Capture Document</label>
        <input type="file" class="form-control" name="document" accept="image/*,.pdf" required>
      </div>
      <div class="d-grid">
        <button type="submit" class="btn btn-primary">Send OTP</button>
      </div>
      <div id="formMessage" class="alert d-none mt-3"></div>
    </form>
  </div>
</div>

<script>
document.getElementById("gateForm").addEventListener("submit", async function(e){
  e.preventDefault();
  let formData = new FormData(this);

  let res = await fetch("gate_enquiry_process.php", {
    method: "POST",
    body: formData
  });

  let data = await res.json();
  let msgBox = document.getElementById("formMessage");
  msgBox.classList.remove("d-none", "alert-danger", "alert-success");

  if(data.success){
    msgBox.classList.add("alert-success");
    msgBox.textContent = data.message;
    setTimeout(()=>window.location.href="verify_otp.php?enquiry_id="+data.enquiry_id, 1500);
  } else {
    msgBox.classList.add("alert-danger");
    msgBox.textContent = data.message;
  }
});
</script>
<?php include_once 'footer.php'; ?>

<script>
function toggleSiblingDetails() {
    const val = document.getElementById('siblings').value;
    document.getElementById('siblingDetailsBox').style.display = (val === 'Yes') ? 'block' : 'none';
}

// Handle form submission with JSON
document.getElementById('studentRegistrationForm').addEventListener('submit', function (e) {
    e.preventDefault();
    const form = this;
    const formData = new FormData(form);

    fetch('student_registration_step1_action.php', {
        method: 'POST',
        body: formData,
        credentials: 'same-origin'
    })
    .then(res => res.text())
    .then(text => {
        console.debug('Raw response:', text);
        let data;
        try { data = JSON.parse(text); } 
        catch (err) {
            alert('Invalid response: ' + text);
            return;
        }

        if (data.status === 'success') {
            document.getElementById('uniqueRegNumber').textContent = data.uniqueId;
            document.getElementById('generatedIdDisplay').style.display = 'block';
            form.reset();
            window.location.href = 'student_registration_step2.php?reg=' + encodeURIComponent(data.uniqueId);
        } else {
            alert('Error: ' + (data.message || 'Unknown error'));
        }
    })
    .catch(err => {
        console.error(err);
        alert('Network error. Please try again.');
    });
});
</script>

