<?php
// get_room_details.php - Fetches details for a single room by ID

// Enable full error reporting for debugging. REMOVE IN PRODUCTION!
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'config.php'; // Include database configuration
header('Content-Type: application/json'); // Set header to return JSON response

if (isset($_GET['id']) && !empty($_GET['id'])) {
    $roomId = filter_var($_GET['id'], FILTER_SANITIZE_NUMBER_INT);

    if ($roomId === false) {
        echo json_encode(['success' => false, 'message' => 'Invalid room ID.']);
        exit;
    }

    // Join with floors and hostels to get related names for display in modal
    $sql = "SELECT r.room_id, r.floor_id, r.room_number, r.room_type, r.capacity, r.current_occupancy,
                   f.hostel_id, f.floor_number, h.name AS hostel_name
            FROM rooms r
            JOIN floors f ON r.floor_id = f.floor_id
            JOIN hostels h ON f.hostel_id = h.hostel_id
            WHERE r.room_id = :room_id";

    try {
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':room_id', $roomId, PDO::PARAM_INT);
        $stmt->execute();
        $room = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($room) {
            echo json_encode(['success' => true, 'room' => $room]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Room not found.']);
        }
    } catch (PDOException $e) {
        error_log("Database error fetching room details: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'A database error occurred while fetching details.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Room ID not provided.']);
}

