<?php
// Ensure session is started if not already
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}
// Default title if not set by the page
$pageTitle = $pageTitle ?? 'Hostel Management System';
// Get admin details for header if logged in
$admin_username = $_SESSION['username'] ?? '';
$admin_full_name = $_SESSION['full_name'] ?? 'Guest';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle); ?></title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        :root {
            --primary-color: #007bff;
            --secondary-color: #6c757d;
            --success-color: #28a745;
            --danger-color: #dc3545;
            --info-color: #17a2b8;
            --warning-color: #ffc107;
            --light-color: #f8f9fa;
            --dark-color: #343a40;
            --sidebar-width: 250px;
            --header-height: 60px;
            --footer-height: 50px;
        }
        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--light-color);
            margin: 0;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            padding-top: var(--header-height); /* Space for fixed header */
            padding-bottom: var(--footer-height); /* Space for fixed footer */
        }
        /* Header Styling */
        .app-header {
            background-color: var(--dark-color);
            color: white;
            height: var(--header-height);
            display: flex;
            align-items: center;
            padding: 0 15px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
            position: fixed;
            width: 100%;
            top: 0;
            left: 0;
            z-index: 1030; /* Above sidebar */
        }
        .app-header .navbar-brand {
            color: white;
            font-weight: bold;
            font-size: 1.5rem;
            text-decoration: none;
        }
        .app-header .navbar-brand:hover {
            color: #e9ecef;
        }
        .sidebar-toggler {
            background: none;
            border: none;
            color: white;
            font-size: 1.5rem;
            cursor: pointer;
            padding: 0 10px;
            transition: transform 0.3s ease;
        }
        /* Sidebar Styling (only relevant for dashboard, but included here for global styles) */
        .app-sidebar {
            width: var(--sidebar-width);
            background-color: var(--dark-color);
            color: white;
            position: fixed;
            top: var(--header-height);
            left: 0;
            height: calc(100% - var(--header-height) - var(--footer-height));
            overflow-y: auto;
            transition: transform 0.3s ease;
            transform: translateX(0); /* Default: visible on desktop */
            z-index: 1020;
            box-shadow: 2px 0 5px rgba(0, 0, 0, 0.1);
            padding-top: 20px;
        }
        .app-sidebar.collapsed {
            transform: translateX(-var(--sidebar-width)); /* Moves sidebar off-screen to the left */
        }
        .app-sidebar .nav-link {
            color: #adb5bd;
            padding: 12px 20px;
            display: flex;
            align-items: center;
            border-radius: 0.5rem;
            margin: 5px 10px;
            transition: background-color 0.2s ease, color 0.2s ease;
        }
        .app-sidebar .nav-link:hover,
        .app-sidebar .nav-link.active {
            background-color: var(--primary-color);
            color: white;
        }
        .app-sidebar .nav-link i {
            margin-right: 10px;
            font-size: 1.1rem;
        }
        /* Main Content Styling - This will be the flexible area */
        .main-content-wrapper {
            flex-grow: 1; /* Allows content to push footer down */
            padding: 20px; /* General padding for content */
            margin-left: var(--sidebar-width); /* Default: shifted for desktop sidebar */
            transition: margin-left 0.3s ease; /* For sidebar transitions */
        }
        /* Class to apply when sidebar is collapsed on desktop */
        .main-content-wrapper.content-full-width {
            margin-left: 0;
        }
        /* Styles for forms (login/register/student) */
        .form-container {
            background-color: #ffffff;
            border-radius: 1rem;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
            padding: 40px;
            width: 100%;
            max-width: 450px; /* Default max-width for login/register */
            text-align: center;
        }
        .form-container.wide { /* For wider forms like student registration */
            max-width: 800px;
            text-align: left; /* Align text left for forms like student registration */
        }
        .form-header {
            margin-bottom: 30px;
        }
        .form-header h2 {
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 10px;
        }
        .form-control, .form-select {
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
            border: 1px solid #ced4da;
            transition: border-color 0.2s ease, box-shadow 0.2s ease;
        }
        .form-control:focus, .form-select:focus {
            border-color: #80bdff;
            box-shadow: 0 0 0 0.25rem rgba(0, 123, 255, 0.25);
        }
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            padding: 10px 25px;
            font-size: 1.1rem;
            border-radius: 0.75rem;
            width: 100%; /* Default for login/register buttons */
            transition: background-color 0.2s ease, border-color 0.2s ease, transform 0.2s ease;
        }

        .btn-primary:hover {
            background-color: #0056b3;
            border-color: #0056b3;
            transform: translateY(-2px);
        }

        .form-text a {
            color: var(--primary-color);
            text-decoration: none;
            font-weight: 500;
        }

        .form-text a:hover {
            text-decoration: underline;
        }

        .alert-message {
            margin-top: 20px;
            padding: 10px 15px;
            border-radius: 0.5rem;
            font-size: 0.95rem;
            display: none; /* Hidden by default */
        }

        /* Footer Styling */
        .app-footer {
            background-color: var(--dark-color);
            color: white;
            height: var(--footer-height);
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 15px;
            text-align: center;
            box-shadow: 0 -2px 4px rgba(0, 0, 0, 0.1);
            position: fixed; /* Fix footer at bottom */
            width: 100%;
            bottom: 0;
            left: 0;
            z-index: 1030;
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .app-sidebar {
                transform: translateX(-var(--sidebar-width)); /* Hidden by default on mobile */
            }
            .app-sidebar.collapsed { /* On mobile, 'collapsed' means visible */
                transform: translateX(0);
            }
            .main-content-wrapper {
                margin-left: 0; /* Always full width on mobile unless sidebar is open */
                padding: 15px; /* Adjust padding for smaller screens */
            }
            .main-content-wrapper.content-full-width { /* On mobile, this class doesn't change anything if margin-left is already 0 */
                margin-left: 0;
            }
            .main-content-wrapper.mobile-sidebar-open { /* New class for when sidebar is open on mobile */
                margin-left: var(--sidebar-width);
            }
            .sidebar-toggler {
                display: block; /* Show toggler on small screens */
            }
        }
    </style>
</head>
<body>
    <!-- Header -->
  
    <!-- The main content for each page will go here -->
    <div class="main-content-wrapper <?php null ? 'd-flex flex-column' : 'd-flex justify-content-center align-items-center'; ?>" id="mainContentWrapper">
        <!-- Content will be included by individual pages -->
