<?php
// student_outpass.php
session_start();
require_once 'db.php';
require_once 'otp_sms_helper.php';
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}
$pageTitle = 'Outpass';
require_once 'config.php';
include_once '_header.php';
include_once '_sidebar.php';

// Fetch classes for dropdown
$classes = [];
$cq = $conn->query("SELECT class_name FROM classes ORDER BY class_name ASC");
if ($cq && $cq->num_rows > 0) {
    while ($r = $cq->fetch_assoc()) {
        $classes[] = $r['class_name'];
    }
}
$selectedClass = isset($_GET['class']) ? trim($_GET['class']) : '';
$students = [];

$sql = "SELECT unique_reg_number, full_name, class_grade, section, admission_number,
               father_guardian_mobile, mother_mobile, school
        FROM students";
$params = [];
$types  = '';

if ($selectedClass !== '') {
    $sql .= " WHERE class_grade = ?";
    $types = 's';
    $params[] = $selectedClass;
}
$sql .= " ORDER BY full_name ASC";

$stmt = $conn->prepare($sql);
if ($types) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$res = $stmt->get_result();
while ($row = $res->fetch_assoc()) {
    $students[] = $row;
}
$stmt->close();
?>
<main class="container-fluid" id="appContent">
    <h5 class="mb-4">Student Outpass</h5>

    <div class="card mb-3">
        <div class="card-body">
            <form class="row g-3" method="GET" action="student_outpass.php">
                <div class="col-md-4">
                    <label class="form-label">Filter by Class</label>
                    <select class="form-select" name="class">
                        <option value="">-- All Classes --</option>
                        <?php foreach ($classes as $cls): ?>
                            <option value="<?= htmlspecialchars($cls) ?>" <?= $selectedClass === $cls ? 'selected' : '' ?>>
                                <?= htmlspecialchars($cls) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-2 align-self-end">
                    <button class="btn btn-primary w-100" type="submit">Apply</button>
                </div>
                <div class="col-md-2 align-self-end">
                    <a class="btn btn-primary w-100" href="student_outpass.php">Reset</a>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-header">Students List</div>
        <div class="card-body">
            <div class="table-responsive">
                <table id="studentsTable" class="table table-striped table-hover">
                    <thead>
                        <tr>
                            <th>Reg No</th>
                            <th>Name</th>
                            <th>Class</th>
                            <th>Section</th>
                            <th>Admission No</th>
                            <th>School</th>
                            <th>Father Mobile</th>
                            <th>Mother Mobile</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($students as $s): ?>
                        <tr>
                            <td><?= htmlspecialchars($s['unique_reg_number']) ?></td>
                            <td><?= htmlspecialchars($s['full_name']) ?></td>
                            <td><?= htmlspecialchars($s['class_grade']) ?></td>
                            <td><?= htmlspecialchars($s['section']) ?></td>
                            <td><?= htmlspecialchars($s['admission_number']) ?></td>
                            <td><?= htmlspecialchars($s['school']) ?></td>
                            <td><?php mask_middle4($s['father_guardian_mobile']) ?></td>
                            <td><?php mask_middle4($s['mother_mobile']) ?></td>
                            <td>
                                <a class="btn btn-sm btn-primary"
                                   href="request_outpass.php?reg=<?= urlencode($s['unique_reg_number']) ?>">
                                    Generate Outpass
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>Reg No</th>
                            <th>Name</th>
                            <th>Class</th>
                            <th>Section</th>
                            <th>Admission No</th>
                            <th>School</th>
                            <th>Father Mobile</th>
                            <th>Mother Mobile</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
            <?php if (empty($students)): ?>
                <div class="alert alert-info mt-3">No students found for this filter.</div>
            <?php endif; ?>
        </div>
    </div>
</main>

<?php include_once 'footer.php'; ?>

<!-- DataTables + Buttons (CSV/Excel/PDF/Print) -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
<script>
$(function(){
    $('#studentsTable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'pageLength', 'csv', 'excel', 'pdf', 'print'
        ],
        lengthMenu: [[10,25,50,100,-1],[10,25,50,100,'All']],
        order: [[1,'asc']]
    });
});
</script>
