<?php
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}
$pageTitle = 'Students Registration - Step 1';
require_once 'config.php'; // (must NOT echo anything)
include_once '_header.php';
include_once '_sidebar.php';
?>

<?php
$enquiry_id = $_GET['enquiry_id'] ?? 0;
?>
<div class="container vh-100 d-flex align-items-center justify-content-center">
  <div class="card shadow-lg p-4" style="max-width:400px;width:100%">
    <h4 class="mb-3 text-center">Verify OTP</h4>
    <form id="otpForm">
      <input type="hidden" name="enquiry_id" value="<?php echo $enquiry_id; ?>">
      <div class="mb-3">
        <label class="form-label">Enter OTP</label>
        <input type="text" name="otp" class="form-control" maxlength="6" required>
      </div>
      <div class="d-grid">
        <button type="submit" class="btn btn-success">Verify</button>
      </div>
      <div id="otpMessage" class="alert d-none mt-3"></div>
    </form>
  </div>
</div>
<?php include_once 'footer.php'; ?>
<script>
document.getElementById("otpForm").addEventListener("submit", async function(e){
  e.preventDefault();
  let formData = new FormData(this);
  let res = await fetch("verify_otp_process.php", {method:"POST", body: formData});
  let data = await res.json();
  let msgBox = document.getElementById("otpMessage");
  msgBox.classList.remove("d-none","alert-danger","alert-success");

  if(data.success){
    msgBox.classList.add("alert-success");
    msgBox.textContent = data.message;
    setTimeout(()=>window.location.href="thank_you.php",1000);
  } else {
    msgBox.classList.add("alert-danger");
    msgBox.textContent = data.message;
  }
});
</script>
