<?php
session_start();
require_once 'db.php';

// Auth check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

$pageTitle = "View Rooms";
include_once '_header.php';
include_once '_sidebar.php';
?>
<main class="container-fluid" id="appContent">
    <h5 class="mb-4">View Rooms</h5>

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table id="roomsTable" class="table table-striped table-bordered display nowrap" style="width:100%">
                    <thead class="table-dark">
                        <tr>
                            <th>Room ID</th>
                            <th>Hostel Name</th>
                            <th>Floor Number</th>
                            <th>Room Number</th>
                            <th>Room Type</th>
                            <th>Capacity</th>
                            <th>Current Occupancy</th>
                            <th>Created At</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $sql = "SELECT r.room_id, h.name AS hostel_name, f.floor_number, r.room_number, 
                                       r.room_type, r.capacity, r.current_occupancy, r.created_at
                                FROM rooms r
                                JOIN floors f ON r.floor_id = f.floor_id
                                JOIN hostels h ON f.hostel_id = h.hostel_id
                                ORDER BY r.created_at DESC";
                        $result = $conn->query($sql);

                        if ($result && $result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                echo "<tr>
                                    <td>{$row['room_id']}</td>
                                    <td>" . htmlspecialchars($row['hostel_name']) . "</td>
                                    <td>" . htmlspecialchars($row['floor_number']) . "</td>
                                    <td><a href='view_beds.php?room_id={$row['room_id']}'>" . htmlspecialchars($row['room_number']) . "</a></td>
                                    <td>" . ucfirst($row['room_type']) . "</td>
                                    <td>{$row['capacity']}</td>
                                    <td>{$row['current_occupancy']}</td>
                                    <td>{$row['created_at']}</td>
                                    <td>
                                        <a href='edit_room.php?id={$row['room_id']}' class='btn btn-sm btn-warning'>Edit</a>
                                        <a href='delete_room.php?id={$row['room_id']}' class='btn btn-sm btn-danger' onclick=\"return confirm('Delete this room?');\">Delete</a>
                                    </td>
                                </tr>";
                            }
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script>
$(document).ready(function() {
    $('#roomsTable').DataTable({
        responsive: true,
        scrollX: true,
        dom: '<"d-flex justify-content-between align-items-center mb-3"lBf>rtip',
        // l = length menu, B = buttons, f = search box
        buttons: [
            { extend: 'excelHtml5', title: 'Rooms_List', className: 'btn btn-success btn-sm me-2' },
            { extend: 'print', title: 'Rooms_List', className: 'btn btn-info btn-sm' }
        ],
        lengthMenu: [
            [10, 25, 50, 100, -1],
            [10, 25, 50, 100, "All"]
        ],
        pageLength: 10
    });

    // Force export buttons to stay inline
    $('.dt-buttons').addClass('d-flex gap-2');
});

</script>
<?php include_once 'footer.php'; ?>
