<?php
session_start();
// Auth check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}
require_once 'db.php';
$pageTitle = "View";
include_once '_header.php';
include_once '_sidebar.php';
?>
<main class="container-fluid" id="appContent">
    <h5 class="mb-4">View Inactive Students</h5>
    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table id="studentsTable" class="table table-striped table-bordered display nowrap" style="width:100%">
                    <thead class="table-dark">
                        <tr>
                            <th>Photo</th>
                            <th>Reg No</th>
                            <th>Full Name</th>
                            <th>Class</th>
                            <th>Section</th>
                            <th>Admission No</th>
                            <th>DOB</th>
                            <th>Gender</th>
                            <th>Status</th>
                             <th>Hostel</th>
                            <th>Aadhar No</th>
                            <th>Father's Name</th>
                            <th>Father Mobile</th>
                            <th>Mother's Name</th>
                            <th>Emergency Contact</th>
                            <th>Emergency Mobile</th>
                            <th>Preferred Room</th>
                            <th>State</th>
                           
                            <th>Floor</th>
                            <th>Room</th>
                            <th>Bed</th>
                            <th>Created At</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $sql = "SELECT s.unique_reg_number, s.full_name, s.class_grade, s.section, 
                                       s.admission_number, s.dob, s.gender,s.status, s.aadhar_number, 
                                       s.father_name, s.father_guardian_mobile, s.mother_name, 
                                       s.emergency_contact_name, s.emergency_mobile, 
                                       s.preferred_room_type, s.state, s.created_at, s.photo_path,
                                       h.name AS hostel_name, f.floor_number, r.room_number, b.bed_number
                                FROM students s
                                LEFT JOIN student_assignments sa ON s.unique_reg_number = sa.unique_reg_number AND sa.status = 'assigned'
                                LEFT JOIN beds b ON sa.bed_id = b.bed_id
                                LEFT JOIN rooms r ON b.room_id = r.room_id
                                LEFT JOIN floors f ON r.floor_id = f.floor_id
                                LEFT JOIN hostels h ON f.hostel_id = h.hostel_id 
                                WHERE s.status = 'inactive'
                                ORDER BY s.created_at DESC";

                        $result = $conn->query($sql);
                        if ($result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                $photo = !empty($row['photo_path']) 
                                    ? '<img src="'.htmlspecialchars($row['photo_path']).'" alt="Photo" class="img-thumbnail" style="width:150px;height:150px;object-fit:cover;">' 
                                    : '<span class="text-muted">No Photo</span>';

                                echo "<tr>
                                    <td>{$photo}</td>
                                    <td>".htmlspecialchars($row['unique_reg_number'])."</td>
                                    <td>".htmlspecialchars($row['full_name'])."</td>
                                    <td>".htmlspecialchars($row['class_grade'])."</td>
                                    <td>".htmlspecialchars($row['section'])."</td>
                                    <td>".htmlspecialchars($row['admission_number'])."</td>
                                    <td>".htmlspecialchars($row['dob'])."</td>
                                    <td>".htmlspecialchars($row['gender'])."</td>
                                    <td>".htmlspecialchars($row['status'])."</td>
                                      <td>".htmlspecialchars($row['hostel_name'] ?? 'N/A')."</td>
                                    <td>".htmlspecialchars($row['aadhar_number'])."</td>
                                    <td>".htmlspecialchars($row['father_name'])."</td>
                                    <td>".htmlspecialchars($row['father_guardian_mobile'])."</td>
                                    <td>".htmlspecialchars($row['mother_name'])."</td>
                                    <td>".htmlspecialchars($row['emergency_contact_name'])."</td>
                                    <td>".htmlspecialchars($row['emergency_mobile'])."</td>
                                    <td>".htmlspecialchars($row['preferred_room_type'])."</td>
                                    <td>".htmlspecialchars($row['state'])."</td>
                                  
                                    <td>".htmlspecialchars($row['floor_number'] ?? 'N/A')."</td>
                                    <td>".htmlspecialchars($row['room_number'] ?? 'N/A')."</td>
                                    <td>".htmlspecialchars($row['bed_number'] ?? 'N/A')."</td>
                                    <td>".htmlspecialchars($row['created_at'])."</td>
                                    <td>
                                        <a href='view_student_profile.php?reg=".urlencode($row['unique_reg_number'])."' 
                                           class='btn btn-sm btn-info'>View Profile</a>
                                    </td>
                                </tr>";
                            }
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<!-- DataTables & Buttons CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.dataTables.min.css">

<!-- jQuery & DataTables JS -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>

<script>
$(document).ready(function() {
    $('#studentsTable').DataTable({
        responsive: {
            details: {
                display: $.fn.dataTable.Responsive.display.modal({
                    header: function (row) {
                        var data = row.data();
                        return 'Details for ' + data[2]; // Full Name in modal header
                    }
                }),
                renderer: $.fn.dataTable.Responsive.renderer.tableAll({
                    tableClass: 'table'
                })
            }
        },
        scrollX: true,
         dom: '<"d-flex justify-content-between align-items-center mb-3"lBf>rtip',
          lengthMenu: [
            [10, 25, 50, 100, -1],
            [10, 25, 50, 100, "All"]
        ],
        buttons: [
            { extend: 'excelHtml5', title: 'Students_List' },
            { extend: 'csvHtml5', title: 'Students_List' }
        ]
    });
});
</script>

<?php include_once 'footer.php'; ?>
