<?php
require_once 'db.php';

if (!isset($_GET['hostel_id']) || empty($_GET['hostel_id'])) {
    echo '<option value="">Choose Floor...</option>';
    exit;
}

$hostel_id = intval($_GET['hostel_id']);

$sql = "SELECT floor_id, floor_number 
        FROM floors 
        WHERE hostel_id = ? 
        ORDER BY floor_number ASC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $hostel_id);
$stmt->execute();
$result = $stmt->get_result();

echo '<option value="">Choose Floor...</option>';
while ($row = $result->fetch_assoc()) {
    echo '<option value="'.$row['floor_id'].'">Floor '.$row['floor_number'].'</option>';
}

$stmt->close();
$conn->close();
