<?php
// get_rooms_by_floor.php - Fetches rooms for a given floor_id

// Enable full error reporting for debugging. REMOVE IN PRODUCTION!
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once 'config.php';
header('Content-Type: application/json');

if (isset($_GET['floor_id']) && !empty($_GET['floor_id'])) {
    $floorId = filter_var($_GET['floor_id'], FILTER_SANITIZE_NUMBER_INT);

    if ($floorId === false) {
        echo json_encode(['success' => false, 'message' => 'Invalid floor ID provided.']);
        exit;
    }

    $sql = "SELECT room_id, room_number, room_type, capacity, current_occupancy FROM rooms WHERE floor_id = :floor_id ORDER BY room_number ASC";

    try {
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':floor_id', $floorId, PDO::PARAM_INT);
        $stmt->execute();
        $rooms = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($rooms) {
            echo json_encode(['success' => true, 'rooms' => $rooms]);
        } else {
            // It's a success if no rooms are found, just return an empty array
            echo json_encode(['success' => true, 'message' => 'No rooms found for this floor.', 'rooms' => []]);
        }
    } catch (PDOException $e) {
        error_log("Database error in get_rooms_by_floor.php: " . $e->getMessage());
        // IMPORTANT: For debugging, return the full PDO error message
        echo json_encode(['success' => false, 'message' => 'A database error occurred: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Floor ID not provided.']);
}

