<?php
require_once 'config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bed_id'])) {
    $bedId = intval($_POST['bed_id']);

    try {
        // Mark assignment as vacated
        $stmt = $pdo->prepare("UPDATE student_assignments 
                               SET status = 'vacated' 
                               WHERE bed_id = ? AND status = 'assigned'");
        $stmt->execute([$bedId]);

        // Set bed free
        $stmt2 = $pdo->prepare("UPDATE beds SET is_occupied = 0 WHERE bed_id = ?");
        $stmt2->execute([$bedId]);

        echo json_encode(["status" => "success", "message" => "Bed vacated successfully"]);
    } catch (Exception $e) {
        echo json_encode(["status" => "error", "message" => $e->getMessage()]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request"]);
}
