<?php
session_start();

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

$admin_username = $_SESSION['username'] ?? 'Admin';
$admin_full_name = $_SESSION['full_name'] ?? 'Administrator';

$pageTitle = 'Admin Dashboard - Hostel Management';
require_once 'db.php';
include_once '_header.php';
include_once '_sidebar.php';

// ======== STATS ======== //
$totalHostels = $conn->query("SELECT COUNT(*) AS total FROM hostels")->fetch_assoc()['total'] ?? 0;
$totalStudents = $conn->query("SELECT COUNT(*) AS total FROM students")->fetch_assoc()['total'] ?? 0;
$totalActiveStudents = $conn->query("SELECT COUNT(*) AS total FROM students WHERE status='active'")->fetch_assoc()['total'] ?? 0;
$totalInactiveStudents = $conn->query("SELECT COUNT(*) AS total FROM students WHERE status='inactive'")->fetch_assoc()['total'] ?? 0;

$totalFloors = $conn->query("SELECT COUNT(*) AS total FROM floors")->fetch_assoc()['total'] ?? 0;
$totalRooms = $conn->query("SELECT COUNT(*) AS total FROM rooms")->fetch_assoc()['total'] ?? 0;
$totalBeds = $conn->query("SELECT COUNT(*) AS total FROM beds")->fetch_assoc()['total'] ?? 0;
$availableBeds = $conn->query("SELECT COUNT(*) AS total FROM beds WHERE is_occupied = 0")->fetch_assoc()['total'] ?? 0;

// Male & Female Counts
$totalMaleStudents = $conn->query("SELECT COUNT(*) AS total FROM students WHERE gender='male' and status ='active'")->fetch_assoc()['total'] ?? 0;
$totalFemaleStudents = $conn->query("SELECT COUNT(*) AS total FROM students WHERE gender='female' and status ='active'")->fetch_assoc()['total'] ?? 0;

// ======== RECENT ASSIGNMENTS ======== //
$recentAssignments = $conn->query("
    SELECT s.full_name, h.name AS hostel_name, f.floor_number, r.room_number, b.bed_number, sa.assigned_date
    FROM student_assignments sa
    JOIN students s ON sa.unique_reg_number = s.unique_reg_number
    JOIN beds b ON sa.bed_id = b.bed_id
    JOIN rooms r ON b.room_id = r.room_id
    JOIN floors f ON r.floor_id = f.floor_id
    JOIN hostels h ON f.hostel_id = h.hostel_id
    ORDER BY sa.assigned_date DESC
    LIMIT 5
");
?>
<main class="container-fluid" id="appContent">
    <h1 class="mb-4">Admin Dashboard</h1>

    <div class="row">
        <!-- Total Hostels -->
        <div class="col-md-3 mb-3">
            <a href="hostels.php" class="text-decoration-none">
                <div class="card text-white bg-primary">
                    <div class="card-body">
                        <h5 class="card-title"><i class="fas fa-building me-2"></i> Total Hostels</h5>
                        <p class="card-text fs-3"><?php echo $totalHostels; ?></p>
                    </div>
                </div>
            </a>
        </div>

        <!-- Total Students -->
        <div class="col-md-3 mb-3">
            <a href="view_students.php" class="text-decoration-none">
                <div class="card text-white bg-success">
                    <div class="card-body">
                        <h5 class="card-title"><i class="fas fa-user-graduate me-2"></i> Total Students</h5>
                        <p class="card-text fs-3"><?php echo $totalStudents; ?></p>
                    </div>
                </div>
            </a>
        </div>

        <!-- Active Students -->
        <div class="col-md-3 mb-3">
            <a href="view_students_active.php" class="text-decoration-none">
                <div class="card text-white bg-info">
                    <div class="card-body">
                        <h5 class="card-title"><i class="fas fa-user-check me-2"></i> Active Students</h5>
                        <p class="card-text fs-3"><?php echo $totalActiveStudents; ?></p>
                    </div>
                </div>
            </a>
        </div>

        <!-- Inactive Students -->
        <div class="col-md-3 mb-3">
            <a href="view_students_inactive.php" class="text-decoration-none">
                <div class="card text-white bg-secondary">
                    <div class="card-body">
                        <h5 class="card-title"><i class="fas fa-user-times me-2"></i> Inactive Students</h5>
                        <p class="card-text fs-3"><?php echo $totalInactiveStudents; ?></p>
                    </div>
                </div>
            </a>
        </div>

        <!-- Floors -->
        <div class="col-md-3 mb-3">
            <a href="view_floors.php" class="text-decoration-none">
                <div class="card text-white bg-warning">
                    <div class="card-body">
                        <h5 class="card-title"><i class="fas fa-layer-group me-2"></i> Total Floors</h5>
                        <p class="card-text fs-3"><?php echo $totalFloors; ?></p>
                    </div>
                </div>
            </a>
        </div>

        <!-- Rooms -->
        <div class="col-md-3 mb-3">
            <a href="view_rooms.php" class="text-decoration-none">
                <div class="card text-white bg-dark">
                    <div class="card-body">
                        <h5 class="card-title"><i class="fas fa-door-open me-2"></i> Total Rooms</h5>
                        <p class="card-text fs-3"><?php echo $totalRooms; ?></p>
                    </div>
                </div>
            </a>
        </div>

        <!-- Beds -->
        <div class="col-md-3 mb-3">
            <a href="view_beds.php" class="text-decoration-none">
                <div class="card text-white bg-danger">
                    <div class="card-body">
                        <h5 class="card-title"><i class="fas fa-bed me-2"></i> Total Beds</h5>
                        <p class="card-text fs-3"><?php echo $totalBeds; ?></p>
                    </div>
                </div>
            </a>
        </div>

        <!-- Available Beds -->
        <div class="col-md-3 mb-3">
            <a href="view_beds.php?available=1" class="text-decoration-none">
                <div class="card text-white bg-success">
                    <div class="card-body">
                        <h5 class="card-title"><i class="fas fa-bed me-2"></i> Available Beds</h5>
                        <p class="card-text fs-3"><?php echo $availableBeds; ?></p>
                    </div>
                </div>
            </a>
        </div>

        <!-- Male Students -->
        <div class="col-md-3 mb-3">
            <a href="view_students.php?gender=male" class="text-decoration-none">
                <div class="card text-white bg-primary">
                    <div class="card-body">
                        <h5 class="card-title"><i class="fas fa-male me-2"></i> Boys Students</h5>
                        <p class="card-text fs-3"><?php echo $totalMaleStudents; ?></p>
                    </div>
                </div>
            </a>
        </div>

        <!-- Female Students -->
        <div class="col-md-3 mb-3">
            <a href="view_students.php?gender=female" class="text-decoration-none">
                <div class="card text-white bg-pink" style="background-color:#e83e8c!important;">
                    <div class="card-body">
                        <h5 class="card-title"><i class="fas fa-female me-2"></i> Girls Students</h5>
                        <p class="card-text fs-3"><?php echo $totalFemaleStudents; ?></p>
                    </div>
                </div>
            </a>
        </div>
    </div>

    <!-- Recent Assignments -->
    <div class="card">
        <div class="card-header">
            Recent Student Assignments
        </div>
        <div class="card-body table-responsive">
            <table class="table table-bordered table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>Student Name</th>
                        <th>Hostel</th>
                        <th>Floor</th>
                        <th>Room</th>
                        <th>Bed</th>
                        <th>Assigned Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($recentAssignments->num_rows > 0): ?>
                        <?php while ($row = $recentAssignments->fetch_assoc()): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($row['full_name']); ?></td>
                                <td><?php echo htmlspecialchars($row['hostel_name']); ?></td>
                                <td><?php echo htmlspecialchars($row['floor_number']); ?></td>
                                <td><?php echo htmlspecialchars($row['room_number']); ?></td>
                                <td><?php echo htmlspecialchars($row['bed_number']); ?></td>
                                <td><?php echo htmlspecialchars($row['assigned_date']); ?></td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr><td colspan="6" class="text-center">No recent assignments found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>
<?php include_once 'footer.php'; ?>
