<?php 
session_start(); 
require_once 'db.php';  
// Auth check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}
// Validate reg number
if (!isset($_GET['reg']) || empty($_GET['reg'])) {
    die("Invalid request");
}
$regNo = $_GET['reg'];
// Fetch student details
$stmt = $conn->prepare("SELECT * FROM students WHERE unique_reg_number = ?");
$stmt->bind_param("s", $regNo);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows === 0) {
    die("Student not found");
}
$student = $result->fetch_assoc();
$stmt->close();

$pageTitle = "View Student - " . htmlspecialchars($student['full_name']);
include_once '_header.php'; 
include_once '_sidebar.php'; 
?> 
<main class="container-fluid">
    <h1 class="mb-4">Edit Student</h1>
    <form action="edit_student_action.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="regNo" value="<?php echo htmlspecialchars($student['unique_reg_number']); ?>">
        <!-- Student Info -->
        <div class="card mb-3">
            <div class="card-header">Student Information</div>
            <div class="card-body row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Full Name</label>
                    <input type="text" name="fullName" class="form-control" 
                           value="<?php echo htmlspecialchars($student['full_name']); ?>" required>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="form-label">School</label>
                    <select class="form-select" id="school" name="school" required>
                        <option value="<?php echo htmlspecialchars($student['school']); ?>">
                            <?php echo htmlspecialchars($student['school']); ?>
                        </option>
                        <?php
                        $schoolQuery = $conn->query("SELECT school_name FROM schools ORDER BY school_name ASC");
                        if ($schoolQuery && $schoolQuery->num_rows > 0) {
                            while ($row = $schoolQuery->fetch_assoc()) {
                                echo '<option value="' . htmlspecialchars($row['school_name']) . '">' . 
                                      htmlspecialchars($row['school_name']) . '</option>';
                            }
                        }
                        ?>
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="form-label">Class</label>
                    <select name="classGrade" class="form-select" required>
                        <option value="">-- Select Class --</option>
                        <?php
                        $classQuery = $conn->query("SELECT class_name FROM classes ORDER BY class_name ASC");
                        while ($row = $classQuery->fetch_assoc()) {
                            $selected = ($row['class_name'] === $student['class_grade']) ? 'selected' : '';
                            echo "<option value='".htmlspecialchars($row['class_name'])."' $selected>".
                                 htmlspecialchars($row['class_name'])."</option>";
                        }
                        ?>
                    </select>
                </div>
                <div class="col-md-3 mb-3">
                    <label class="form-label">Section</label>
                    <input type="text" name="section" class="form-control" 
                           value="<?php echo htmlspecialchars($student['section']); ?>">
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Admission No</label>
                    <input type="text" name="admissionNumber" class="form-control" 
                           value="<?php echo htmlspecialchars($student['admission_number']); ?>" required>
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Date of Birth</label>
                    <input type="date" name="dob" class="form-control" 
                           value="<?php echo htmlspecialchars($student['dob']); ?>" required>
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Gender</label>
                    <select name="gender" class="form-select" required>
                        <option value="Male"   <?php if($student['gender']=='Male') echo 'selected'; ?>>Male</option>
                        <option value="Female" <?php if($student['gender']=='Female') echo 'selected'; ?>>Female</option>
                        <option value="Other"  <?php if($student['gender']=='Other') echo 'selected'; ?>>Other</option>
                    </select>
                </div>
                <!-- New Fields -->
                <div class="col-md-4 mb-3">
                    <label class="form-label">Medium</label>
                    <select name="preferredLanguage" class="form-select">
                        <option value="Hindi"   <?php if($student['preferred_language']=='Hindi') echo 'selected'; ?>>Hindi</option>
                        <option value="English" <?php if($student['preferred_language']=='English') echo 'selected'; ?>>English</option>
                    </select>
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Achievement</label>
                    <select name="achievementType" class="form-select">
                        <option value="">-- Select --</option>
                        <option value="Academic" <?php if($student['achievement_type']=='Academic') echo 'selected'; ?>>Academic</option>
                        <option value="Award"    <?php if($student['achievement_type']=='Award') echo 'selected'; ?>>Award</option>
                        <option value="Sport"    <?php if($student['achievement_type']=='Sport') echo 'selected'; ?>>Sport</option>
                    </select>
                </div>
                <div class="col-md-4 mb-3">
                    <label class="form-label">Siblings</label>
                    <select name="siblings" id="siblings" class="form-select">
                        <option value="No"  <?php if($student['siblings']=='No') echo 'selected'; ?>>No</option>
                        <option value="Yes" <?php if($student['siblings']=='Yes') echo 'selected'; ?>>Yes</option>
                    </select>
                </div>

                <div class="col-md-12 mb-3" id="siblingDetailsDiv" 
                     style="<?php echo ($student['siblings']=='Yes') ? '' : 'display:none;'; ?>">
                    <label class="form-label">Sibling Details</label>
                    <textarea name="siblingDetails" class="form-control"><?php echo htmlspecialchars($student['sibling_details']); ?></textarea>
                </div>

                <div class="col-md-12 mb-3">
                    <label class="form-label">Hobbies</label>
                    <textarea name="hobbies" class="form-control"><?php echo htmlspecialchars($student['hobbies']); ?></textarea>
                </div>
            </div>
        </div>
        <!-- Parent Details -->
        <div class="card mb-3">
            <div class="card-header">Parent Details</div>
            <div class="card-body row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Father's Name</label>
                    <input type="text" name="fatherName" class="form-control" 
                           value="<?php echo htmlspecialchars($student['father_name']); ?>">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Father Mobile</label>
                    <input type="text" name="fatherMobile" class="form-control" 
                           value="<?php echo htmlspecialchars($student['father_guardian_mobile']); ?>">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Mother's Name</label>
                    <input type="text" name="motherName" class="form-control" 
                           value="<?php echo htmlspecialchars($student['mother_name']); ?>">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Mother Mobile</label>
                    <input type="text" name="motherMobile" class="form-control" 
                           value="<?php echo htmlspecialchars($student['mother_mobile']); ?>">
                </div>
            </div>
        </div>
        <!-- Address -->
        <div class="card mb-3">
            <div class="card-header">Address Details</div>
            <div class="card-body row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Permanent Address</label>
                    <textarea name="permanentAddress" class="form-control"><?php echo htmlspecialchars($student['permanent_address']); ?></textarea>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Correspondence Address</label>
                    <textarea name="correspondenceAddress" class="form-control"><?php echo htmlspecialchars($student['correspondence_address']); ?></textarea>
                </div>
            </div>
        </div>
        <!-- Stationary -->
        <div class="card mb-3">
            <div class="card-header">Stationary Details</div>
            <div class="card-body">
                <label class="form-label">Stationary (Details)</label>
                <textarea class="form-control" name="stationary" rows="3"><?php echo htmlspecialchars($student['stationary']); ?></textarea>
            </div>
        </div>
        <!-- Photo & Aadhaar -->
        <div class="card mb-3">
            <div class="card-header">Documents</div>
            <div class="card-body row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Student Photo (Max 2MB)</label>
                    <input type="file" name="photo" class="form-control" accept="image/*">
                    <?php if (!empty($student['photo_path'])): ?>
                        <p class="mt-2"><img src="<?php echo htmlspecialchars($student['photo_path']); ?>" style="max-width:100px;"></p>
                    <?php endif; ?>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Aadhaar Card (Max 2MB)</label>
                    <input type="file" name="aadharCard" class="form-control" accept="image/*,application/pdf">
                    <?php if (!empty($student['aadhar_card_path'])): ?>
                        <p class="mt-2"><a href="<?php echo htmlspecialchars($student['aadhar_card_path']); ?>" target="_blank">View Current</a></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <button type="submit" class="btn btn-success">Save Changes</button>
        <a href="view_student_profile.php?reg=<?php echo urlencode($student['unique_reg_number']); ?>" class="btn btn-secondary">Cancel</a>
    </form>
</main>
<script>
// File size validation
document.querySelector('form').addEventListener('submit', function(e) {
    const photo = document.querySelector('input[name="photo"]').files[0];
    const aadhar = document.querySelector('input[name="aadharCard"]').files[0];

    if (photo && photo.size > 2 * 1024 * 1024) {
        alert('Student photo must be less than 2MB');
        e.preventDefault();
    }
    if (aadhar && aadhar.size > 2 * 1024 * 1024) {
        alert('Aadhaar card must be less than 2MB');
        e.preventDefault();
    }
});
// Show/Hide sibling details
document.getElementById('siblings').addEventListener('change', function() {
    const detailsDiv = document.getElementById('siblingDetailsDiv');
    detailsDiv.style.display = (this.value === 'Yes') ? '' : 'none';
});
</script>
<?php include_once 'footer.php'; ?>