<?php
require_once 'db.php';

if (!isset($_GET['room_id']) || empty($_GET['room_id'])) {
    echo '<option value="">Choose Bed...</option>';
    exit;
}

$room_id = intval($_GET['room_id']);

$sql = "SELECT bed_id, bed_number, is_occupied 
        FROM beds 
        WHERE room_id = ? AND is_occupied = 0 
        ORDER BY bed_number ASC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $room_id);
$stmt->execute();
$result = $stmt->get_result();

echo '<option value="">Choose Bed...</option>';
while ($row = $result->fetch_assoc()) {
    echo '<option value="'.$row['bed_id'].'">Bed '.$row['bed_number'].'</option>';
}

$stmt->close();
$conn->close();
