<?php
// otp_sms_helper.php

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/**
 * Generate a 6-digit numeric OTP
 */
function generate_otp(): string {
    return str_pad((string)random_int(0, 999999), 6, '0', STR_PAD_LEFT);
}

/**
 * DEV/DUMMY SMS sender. Replace with real API (Twilio/MSG91/etc.)
 * We keep a debug trail in session for testing.
 */
function send_sms($mobile, $message): bool {
    if (!$mobile) return false;
    $_SESSION['__sms_debug'][] = [
        'to' => $mobile,
        'message' => $message,
        'time' => date('Y-m-d H:i:s')
    ];
    // TODO: integrate SMS provider here
    return true;
}
