<?php
// outpass_list.php
session_start();
require_once 'db.php';
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php'); exit;
}
$pageTitle = "Generated List";
require_once 'config.php';
include_once '_header.php';
include_once '_sidebar.php';
// Fetch all outpasses with student details
$sql = "SELECT o.id, o.unique_reg_number, o.reason, o.created_at, o.otp_verified,
               s.full_name, s.class_grade, s.section, s.admission_number, s.school
        FROM student_outpass o
        JOIN students s ON s.unique_reg_number = o.unique_reg_number
        ORDER BY o.created_at DESC";
$result = $conn->query($sql);
?>
<main class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h1 class="mb-0">Generated Outpasses</h1>
    </div>

    <div class="card shadow">
        <div class="card-body table-responsive">
            <table id="outpassTable" class="table table-bordered table-striped align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>Student</th>
                        <th>Admission No</th>
                        <th>Class</th>
                        <th>School</th>
                        <th>Reason</th>
                        <th>Issued On</th>
                        <th>OTP Verified</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                <?php if ($result && $result->num_rows > 0): ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?= $row['id'] ?></td>
                            <td><?= htmlspecialchars($row['full_name']) ?></td>
                            <td><?= htmlspecialchars($row['admission_number']) ?></td>
                            <td><?= htmlspecialchars($row['class_grade']) ?> <?= htmlspecialchars($row['section']) ?></td>
                            <td><?= htmlspecialchars($row['school']) ?></td>
                            <td><?= htmlspecialchars($row['reason']) ?></td>
                            <td><?= htmlspecialchars($row['created_at']) ?></td>
                            <td>
                                <?php if ($row['otp_verified']): ?>
                                    <span class="badge bg-success">Yes</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">No</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="generate_outpass.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-primary">
                                    View
                                </a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="9" class="text-center">No outpasses generated yet.</td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</main>
<!-- DataTables + Buttons (CSV/Excel/PDF/Print) -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.print.min.js"></script>
<script>
$(function(){
    $('#outpassTable').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'pageLength', 'csv', 'excel', 'pdf', 'print'
        ],
        lengthMenu: [[10,25,50,100,-1],[10,25,50,100,'All']],
        order: [[1,'asc']]
    });
});
</script>
</script>

<?php include_once 'footer.php'; ?>
