<?php
// student_registration_step2.php
session_start();

// Auth check (same as Step 1)
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php_error.log');

$pageTitle = 'Students Registration - Step 1';
require_once 'config.php'; // DB connection
include_once '_header.php';
include_once '_sidebar.php';
?>
<?php

// Get unique_reg_number from query or session
if (isset($_GET['reg']) && !empty($_GET['reg'])) {
    $unique_reg_number = $_GET['reg'];
    $_SESSION['unique_reg_number'] = $unique_reg_number; // store for later steps
} elseif (isset($_SESSION['unique_reg_number'])) {
    $unique_reg_number = $_SESSION['unique_reg_number'];
} else {
    // If no reg number, redirect back to Step 1
    header("Location: student_registration_step1.php");
    exit;
}
?>
<main class="container-fluid" id="appContent">
    <h1 class="mb-4">Student Registration - Step 2</h1>

    <div class="form-header">
        <h2>School Hostel Registration</h2>
        <p class="text-muted">Parent / Guardian Details</p>
    </div>

    <!-- Step Indicator -->
    <div class="step-indicator mb-4">
        <div class="step" id="step1">
            <div class="step-circle">1</div>
            <div class="step-label">Student Info</div>
        </div>
        <div class="step active" id="step2">
            <div class="step-circle">2</div>
            <div class="step-label">Parent Details</div>
        </div>
        <div class="step"><div class="step-circle">3</div><div class="step-label">Address</div></div>
        <div class="step"><div class="step-circle">4</div><div class="step-label">Emergency Contact</div></div>
        <div class="step"><div class="step-circle">5</div><div class="step-label">Hostel Preferences</div></div>
        <div class="step"><div class="step-circle">6</div><div class="step-label">Documents</div></div>
    </div>

    <!-- Parent Details Form -->
    <form id="parentDetailsForm">
        <input type="hidden" name="uniqueId" id="uniqueId" value="<?php echo $unique_reg_number ?>">

        <div class="row g-3 mb-4">
            <div class="col-md-6">
                <label for="fatherName" class="form-label">Father's Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="fatherName" name="fatherName" required>
            </div>
            <div class="col-md-6">
                <label for="motherName" class="form-label">Mother's Name</label>
                <input type="text" class="form-control" id="motherName" name="motherName">
            </div>
            <div class="col-md-6">
                <label for="guardianName" class="form-label">Guardian's Name (if any)</label>
                <input type="text" class="form-control" id="guardianName" name="guardianName">
            </div>
            <div class="col-md-6">
                <label for="relationWithStudent" class="form-label">Relation with Student</label>
                <input type="text" class="form-control" id="relationWithStudent" name="relationWithStudent">
            </div>
            <div class="col-md-6">
                <label for="fatherGuardianMobile" class="form-label">Father / Guardian Mobile <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="fatherGuardianMobile" name="fatherGuardianMobile" required>
            </div>
            <div class="col-md-6">
                <label for="motherMobile" class="form-label">Mother's Mobile</label>
                <input type="text" class="form-control" id="motherMobile" name="motherMobile">
            </div>
            <div class="col-md-12">
                <label for="emailId" class="form-label">Email ID</label>
                <input type="email" class="form-control" id="emailId" name="emailId">
            </div>
        </div>

        <button type="submit" class="btn btn-primary">Save & Continue</button>
    </form>

    <div id="result" class="mt-3"></div>
</main>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    // Get reg number from URL
    const urlParams = new URLSearchParams(window.location.search);
    const regId = urlParams.get('reg');
    if (regId) {
        $('#uniqueId').val(regId);
    }

    $("#parentDetailsForm").on("submit", function(e) {
        e.preventDefault();
        $.ajax({
            url: "student_registration_step2_action.php",
            type: "POST",
            data: $(this).serialize(),
            dataType: "json",
            success: function(data) {
                if (data.status === "success") {
                    $("#result").html('<div class="alert alert-success">'+data.message+'</div>');
                    window.location.href = 'student_registration_step3.php?reg=' + encodeURIComponent(data.uniqueId);
                } else {
                    $("#result").html('<div class="alert alert-danger">'+data.message+'</div>');
                }
            },
            error: function() {
                $("#result").html('<div class="alert alert-danger">An unexpected error occurred</div>');
            }
        });
    });
});
</script>
<?php include_once 'footer.php'; ?>
