<?php
// student_registration_step4.php
session_start();

// Auth check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

$pageTitle = 'Floors Registration - Step 4';
require_once 'config.php';
include_once '_header.php';
include_once '_sidebar.php';
?>
<main class="container-fluid" id="appContent">
    <h1 class="mb-4">Student Registration - Step 4</h1>

    <div class="form-header">
        <h2>School Hostel Registration</h2>
        <p class="text-muted">Emergency Contact Details</p>
    </div>

    <!-- Step Indicator -->
    <div class="step-indicator mb-4">
        <div class="step"><div class="step-circle">1</div><div class="step-label">Student Info</div></div>
        <div class="step"><div class="step-circle">2</div><div class="step-label">Parent Details</div></div>
        <div class="step"><div class="step-circle">3</div><div class="step-label">Address</div></div>
        <div class="step active" id="step4">
            <div class="step-circle">4</div>
            <div class="step-label">Emergency Contact</div>
        </div>
        <div class="step"><div class="step-circle">5</div><div class="step-label">Hostel Preferences</div></div>
        <div class="step"><div class="step-circle">6</div><div class="step-label">Documents</div></div>
    </div>

    <!-- Emergency Contact Form -->
    <form id="emergencyContactForm">
        <input type="hidden" name="uniqueId" id="uniqueId">

        <div class="row g-3 mb-4">
            <div class="col-md-6">
                <label for="emergencyContactName" class="form-label">Emergency Contact Name <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="emergencyContactName" name="emergencyContactName" required>
            </div>
            <div class="col-md-6">
                <label for="emergencyRelation" class="form-label">Relation with Student</label>
                <input type="text" class="form-control" id="emergencyRelation" name="emergencyRelation">
            </div>
            <div class="col-md-6">
                <label for="emergencyMobile" class="form-label">Emergency Mobile <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="emergencyMobile" name="emergencyMobile" required>
            </div>
            <div class="col-md-6">
                <label for="emergencyAlternateNumber" class="form-label">Alternate Number</label>
                <input type="text" class="form-control" id="emergencyAlternateNumber" name="emergencyAlternateNumber">
            </div>
        </div>

        <button type="submit" class="btn btn-primary">Save & Continue</button>
    </form>

    <div id="result" class="mt-3"></div>
</main>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    const urlParams = new URLSearchParams(window.location.search);
    const regId = urlParams.get('reg');
    if (regId) {
        $('#uniqueId').val(regId);
    }

    $("#emergencyContactForm").on("submit", function(e) {
        e.preventDefault();
        $.ajax({
            url: "student_registration_step4_action.php",
            type: "POST",
            data: $(this).serialize(),
            dataType: "json",
            success: function(data) {
                if (data.status === "success") {
                    $("#result").html('<div class="alert alert-success">'+data.message+'</div>');
                    window.location.href = 'student_registration_step5.php?reg=' + encodeURIComponent(data.uniqueId);
                } else {
                    $("#result").html('<div class="alert alert-danger">'+data.message+'</div>');
                }
            },
            error: function() {
                $("#result").html('<div class="alert alert-danger">An unexpected error occurred</div>');
            }
        });
    });
});
</script>
<?php include_once 'footer.php'; ?>
