<?php
// floors.php - Floors Management Page
session_start();
// Check if the admin is NOT logged in
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}
$pageTitle = 'Students - Hostel Management';
require_once 'config.php'; // Include the database configuration
include_once '_header.php';
include_once '_sidebar.php';
?>
    <main class="container-fluid" id="appContent">
        <h1 class="mb-4">Floor Management</h1>

            <div class="form-header">
            <h2>School Hostel Registration</h2>
            <p class="text-muted">Student Details Form</p>
        </div>
        <!-- Step Indicator -->
        <div class="step-indicator">
            <div class="step active" id="step1">
                <div class="step-circle"><i class="fas fa-check"></i> 1</div>
                <div class="step-label">Student Info</div>
            </div>
            <div class="step" id="step2">
                <div class="step-circle"><i class="fas fa-check"></i> 2</div>
                <div class="step-label">Parent Details</div>
            </div>
            <div class="step" id="step3">
                <div class="step-circle"><i class="fas fa-check"></i> 3</div>
                <div class="step-label">Address</div>
            </div>
            <div class="step" id="step4">
                <div class="step-circle"><i class="fas fa-check"></i> 4</div>
                <div class="step-label">Emergency Contact</div>
            </div>
            <div class="step" id="step5">
                <div class="step-circle"><i class="fas fa-check"></i> 5</div>
                <div class="step-label">Hostel Preferences</div>
            </div>
            <div class="step" id="step6">
                <div class="step-circle"><i class="fas fa-check"></i> 6</div>
                <div class="step-label">Documents</div>
            </div>
        </div>

        <!-- Student Information Form Section -->
        <form id="studentRegistrationForm">
            <div class="form-section-title">
                <i class="fas fa-user-graduate"></i> Student Information
            </div>
            <div class="row g-3 mb-4">
                <div class="col-md-6">
                    <label for="fullName" class="form-label">Full Name of Student <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="fullName" name="fullName" required>
                </div>
                <div class="col-md-6">
                    <label for="classGrade" class="form-label">Class / Grade <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="classGrade" name="classGrade" required>
                </div>
                <div class="col-md-6">
                    <label for="section" class="form-label">Section (if applicable)</label>
                    <input type="text" class="form-control" id="section" name="section">
                </div>
                <div class="col-md-6">
                    <label for="admissionNumber" class="form-label">Admission Number / Student ID <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="admissionNumber" name="admissionNumber" required>
                </div>
                <div class="col-md-6">
                    <label for="dob" class="form-label">Date of Birth (DD-MM-YYYY) <span class="text-danger">*</span></label>
                    <input type="date" class="form-control" id="dob" name="dob" required>
                </div>
                <div class="col-md-6">
                    <label for="gender" class="form-label">Gender <span class="text-danger">*</span></label>
                    <select class="form-select" id="gender" name="gender" required>
                        <option value="">Select Gender</option>
                        <option value="Male">Male</option>
                        <option value="Female">Female</option>
                        <option value="Other">Other</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="bloodGroup" class="form-label">Blood Group</label>
                    <input type="text" class="form-control" id="bloodGroup" name="bloodGroup" placeholder="e.g., A+, O-">
                </div>
                <div class="col-md-6">
                    <label for="religion" class="form-label">Religion</label>
                    <input type="text" class="form-control" id="religion" name="religion">
                </div>
                <div class="col-md-6">
                    <label for="category" class="form-label">Category <span class="text-danger">*</span></label>
                    <select class="form-select" id="category" name="category" required>
                        <option value="">Select Category</option>
                        <option value="General">General</option>
                        <option value="SC">SC</option>
                        <option value="ST">ST</option>
                        <option value="OBC">OBC</option>
                        <option value="Others">Others</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="aadharNumber" class="form-label">Aadhar Number (if available)</label>
                    <input type="text" class="form-control" id="aadharNumber" name="aadharNumber" maxlength="12" pattern="[0-9]{12}" title="Aadhar number must be 12 digits">
                </div>
            </div>

            <div class="d-flex justify-content-end">
                <button type="submit" class="btn btn-primary">Next Step <i class="fas fa-arrow-right ms-2"></i></button>
            </div>
        </form>

        <div id="generatedIdDisplay" class="generated-id-box">
            <p>Your Unique Registration Number:</p>
            <h4 id="uniqueRegNumber"></h4>
            <p class="mt-2 text-muted">You can use this number to complete other details later.</p>
        </div>        
    </main>

    <!-- Edit Floor Modal (Placeholder for future functionality) -->
 <script>
        document.addEventListener('DOMContentLoaded', function() {
            const studentRegistrationForm = document.getElementById('studentRegistrationForm');
            const generatedIdDisplay = document.getElementById('generatedIdDisplay');
            const uniqueRegNumberSpan = document.getElementById('uniqueRegNumber');
            const step1Indicator = document.getElementById('step1');

            studentRegistrationForm.addEventListener('submit', function(event) {
                event.preventDefault(); // Prevent default form submission

                // Basic client-side validation
                if (!studentRegistrationForm.checkValidity()) {
                    event.stopPropagation();
                    studentRegistrationForm.classList.add('was-validated');
                    return;
                }

                // Simulate data collection (in a real app, this would be sent to PHP)
                const formData = new FormData(studentRegistrationForm);
                const studentData = {};
                for (let [key, value] of formData.entries()) {
                    studentData[key] = value;
                }

                // Generate a unique registration number (client-side simulation)
                // In a real application, this would be generated server-side (PHP) and stored in the database
                const uniqueId = 'STU-' + Date.now().toString().slice(-8) + Math.random().toString(36).substr(2, 4).toUpperCase();
                studentData['uniqueRegistrationNumber'] = uniqueId;

                console.log('Simulating Student Step 1 Data:', studentData);

                // Display the generated ID
                uniqueRegNumberSpan.textContent = uniqueId;
                generatedIdDisplay.style.display = 'block';

                // Mark step 1 as completed
                step1Indicator.classList.remove('active');
                step1Indicator.classList.add('completed');

                // In a real application, you would then:
                // 1. Send studentData to a PHP script via AJAX (e.g., fetch API)
                // 2. PHP script saves data to database and returns the unique ID
                // 3. Redirect to the next step of the form, passing the unique ID or storing it in session
                // Example: window.location.href = 'student_registration_step2.php?reg_id=' + uniqueId;
                alert("Student Information submitted. Unique Registration Number generated. (Check console for data)");
            });
        });
    </script>
<?php include_once 'footer.php'; ?>
