<?php ob_start(); session_start();
// verify_outpass.php

require_once 'db.php';

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php'); exit;
}

if (!isset($_GET['id']) || !ctype_digit($_GET['id'])) {
    die('Invalid request');
}
$id = (int)$_GET['id'];

// Load outpass + student
$sql = "SELECT o.id, o.unique_reg_number, o.reason, o.otp_code, o.otp_verified, o.created_at,
               s.full_name, s.class_grade, s.section, s.admission_number, s.school
        FROM student_outpass o
        JOIN students s ON s.unique_reg_number = o.unique_reg_number
        WHERE o.id = ?";
$st = $conn->prepare($sql);
$st->bind_param("i", $id);
$st->execute();
$outpass = $st->get_result()->fetch_assoc();
$st->close();

if (!$outpass) { die('Outpass not found'); }

$pageTitle = "Outpass OTP - " . htmlspecialchars($outpass['full_name']);
require_once 'config.php';
include_once '_header.php';
include_once '_sidebar.php';

// Handle post verify
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $code = trim($_POST['otp'] ?? '');
    if ($code === '') {
        $error = "Please enter the OTP.";
    } elseif ($code !== $outpass['otp_code']) {
        $error = "Invalid OTP. Please try again.";
    } else {
        $up = $conn->prepare("UPDATE student_outpass SET otp_verified = 1 WHERE id = ?");
        $up->bind_param("i", $id);
        $up->execute();
        $up->close();
        header('Location: generate_outpass.php?id=' . $id);
        exit;
    }
}
?>
<main class="container-fluid">
    <h1 class="mb-4">Verify OTP</h1>

    <?php if (!empty($error)): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <div class="card mb-3">
        <div class="card-header">Student</div>
        <div class="card-body row">
            <div class="col-md-6 mb-2"><strong>Name:</strong> <?= htmlspecialchars($outpass['full_name']) ?></div>
            <div class="col-md-3 mb-2"><strong>Class:</strong> <?= htmlspecialchars($outpass['class_grade']) ?></div>
            <div class="col-md-3 mb-2"><strong>Section:</strong> <?= htmlspecialchars($outpass['section']) ?></div>
            <div class="col-md-4 mb-2"><strong>Admission No:</strong> <?= htmlspecialchars($outpass['admission_number']) ?></div>
            <div class="col-md-4 mb-2"><strong>School:</strong> <?= htmlspecialchars($outpass['school']) ?></div>
            <div class="col-md-4 mb-2"><strong>Requested On:</strong> <?= htmlspecialchars($outpass['created_at']) ?></div>
        </div>
    </div>

    <form method="POST" class="card">
        <div class="card-header">Enter OTP</div>
        <div class="card-body row g-3">
            <div class="col-md-6">
                <label class="form-label">One-Time Password</label>
                <input type="text" name="otp" class="form-control" maxlength="6" required>
            </div>

            <?php if (!empty($_SESSION['__last_outpass_otp'])): ?>
            <div class="col-12">
                <div class="alert alert-warning p-2 mb-0">
                    <strong>DEV:</strong> For testing, OTP is <strong><?= htmlspecialchars($_SESSION['__last_outpass_otp']) ?></strong>
                    (remove this message in production).
                </div>
            </div>
            <?php endif; ?>
        </div>
        <div class="card-footer text-end">
            <a class="btn btn-secondary" href="student_outpass.php">Cancel</a>
            <button class="btn btn-success" type="submit">Verify</button>
        </div>
    </form>
</main>

<?php include_once 'footer.php'; ?>
