<?php
session_start();
require_once 'db.php';

// Auth check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: admin_login.php');
    exit;
}

$pageTitle = "View Beds";
include_once '_header.php';
include_once '_sidebar.php';

$filterRoom = isset($_GET['room_id']) ? intval($_GET['room_id']) : 0;
?>
<main class="container-fluid" id="appContent">
    <h1 class="mb-4">View Beds <?php if($filterRoom){ echo "(Room #$filterRoom)"; } ?></h1>

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table id="bedsTable" class="table table-striped table-bordered display nowrap" style="width:100%">
                    <thead class="table-dark">
                        <tr>
                            <th>Bed ID</th>
                            <th>Hostel</th>
                            <th>Floor</th>
                            <th>Room</th>
                            <th>Bed</th>
                            <th>Status</th>
                            <th>Assigned Student</th>

                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $sql = "SELECT b.bed_id, h.name AS hostel_name, f.floor_number, r.room_number, 
                                       b.bed_number, b.is_occupied, b.created_at, b.updated_at,
                                       s.full_name, s.unique_reg_number
                                FROM beds b
                                JOIN rooms r ON b.room_id = r.room_id
                                JOIN floors f ON r.floor_id = f.floor_id
                                JOIN hostels h ON f.hostel_id = h.hostel_id
                                LEFT JOIN student_assignments sa ON b.bed_id = sa.bed_id AND sa.status = 'assigned'
                                LEFT JOIN students s ON sa.unique_reg_number = s.unique_reg_number";

                        if ($filterRoom) {
                            $sql .= " WHERE b.room_id = {$filterRoom}";
                        }

                        $sql .= " ORDER BY b.created_at DESC";
                        $result = $conn->query($sql);

                        if ($result && $result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                $statusBadge = $row['is_occupied'] ? '<span class="badge bg-danger">Occupied</span>' : '<span class="badge bg-success">Available</span>';
                                $studentLink = $row['full_name'] 
                                    ? "<a href='view_student_profile.php?reg=" . urlencode($row['unique_reg_number']) . "'>" . htmlspecialchars($row['full_name']) . "</a>" 
                                    : "<span class='text-muted'>—</span>";

                                echo "<tr>
                                    <td>{$row['bed_id']}</td>
                                    <td>" . htmlspecialchars($row['hostel_name']) . "</td>
                                    <td>" . htmlspecialchars($row['floor_number']) . "</td>
                                    <td>" . htmlspecialchars($row['room_number']) . "</td>
                                    <td>" . htmlspecialchars($row['bed_number']) . "</td>
                                    <td>{$statusBadge}</td>
                                    <td>{$studentLink}</td>
                                </tr>";
                            }
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</main>

<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.dataTables.min.css">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script>
$(document).ready(function() {
    $('#bedsTable').DataTable({
        responsive: true,
        scrollX: true,
        dom: '<"d-flex justify-content-between align-items-center mb-3"lBf>rtip',
        // l = length menu, B = buttons, f = search box
        buttons: [
            { extend: 'excelHtml5', title: 'Beds_List', className: 'btn btn-success btn-sm me-1' },
            { extend: 'print', title: 'Beds_List', className: 'btn btn-info btn-sm' }
        ],
        lengthMenu: [
            [10, 25, 50, 100, -1],
            [10, 25, 50, 100, "All"]
        ],
        pageLength: 10
    });

    // Force export buttons to stay inline
    $('.dt-buttons').addClass('d-flex gap-1');
});


</script>
<?php include_once 'footer.php'; ?>
