# Work Allocation Web Application

This is a fully responsive, user-friendly Work Allocation Web Application designed to streamline task assignment and tracking between an employer (admin) and employees. The system features secure login portals for both roles, robust task management functionalities, and interactive communication tools.

## Features

### Admin/Employer Dashboard
- **Secure Login:** Admins can securely log in to manage the system.
- **Employee Management:** Add, edit, and delete employee accounts.
- **Task Assignment:** Assign tasks to employees with deadlines and priority levels.
- **Task Tracking:** View all tasks, track their status (pending, in progress, completed, rejected).
- **Communication:** Communicate with employees through comments and updates on tasks.

### Employee Dashboard
- **Secure Login:** Employees can securely log in to view their assigned tasks.
- **Task Status Updates:** Update the status of assigned tasks.
- **Comments & Updates:** Add comments and progress updates to tasks.
- **File Uploads (Optional - Future Feature):** Upload related work files or attachments.

## Technologies Used

- **Backend:** PHP (Structured, Secure, OOP principles applied)
- **Database:** MySQL
- **Frontend:**
    - HTML5
    - CSS3
    - JavaScript (with jQuery)
    - Bootstrap 5 (for responsive design)
- **Interactive Elements:**
    - AJAX (for comment submission)
    - SweetAlert2 (for confirmation alerts)

## Database Schema

The application uses a MySQL database with the following tables:

- **`users`**: Stores information about both admin and employee users.
    - `user_id` (INT, PK, AUTO_INCREMENT)
    - `username` (VARCHAR, UNIQUE)
    - `password` (VARCHAR, Hashed)
    - `email` (VARCHAR, UNIQUE)
    - `role` (ENUM('admin', 'employee'))
    - `created_at` (TIMESTAMP)

- **`tasks`**: Stores details about assigned tasks.
    - `task_id` (INT, PK, AUTO_INCREMENT)
    - `title` (VARCHAR)
    - `description` (TEXT)
    - `assigned_to` (INT, FK to `users.user_id`)
    - `assigned_by` (INT, FK to `users.user_id`)
    - `deadline` (DATE)
    - `priority` (ENUM('low', 'medium', 'high'))
    - `status` (ENUM('pending', 'in progress', 'completed', 'rejected'))
    - `created_at` (TIMESTAMP)
    - `updated_at` (TIMESTAMP)

- **`comments`**: Stores comments related to tasks.
    - `comment_id` (INT, PK, AUTO_INCREMENT)
    - `task_id` (INT, FK to `tasks.task_id`)
    - `user_id` (INT, FK to `users.user_id`)
    - `comment_text` (TEXT)
    - `created_at` (TIMESTAMP)

## Setup Instructions

Follow these steps to set up and run the application on your local machine.

### Prerequisites

- Web server (e.g., Apache, Nginx)
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Composer (optional, for future dependency management)

### 1. Clone the Repository

If you have Git installed, clone the repository:
```bash
git clone [repository_url]
cd work_allocation_app
```
Otherwise, download the project ZIP and extract it to your web server's document root (e.g., `htdocs` for Apache, `www` for Nginx). Rename the extracted folder to `work_allocation_app`.

### 2. Database Setup

a. **Create Database:**
   Create a new MySQL database named `work_allocation_app`. You can use phpMyAdmin or a MySQL client:
   ```sql
   CREATE DATABASE work_allocation_app;
   ```

b. **Import Schema:**
   Import the provided `database.sql` file into your newly created database.
   ```bash
   mysql -u your_username -p work_allocation_app < database.sql
   ```
   (Replace `your_username` with your MySQL username. You will be prompted for your password.)

### 3. Configure Database Connection

Open the `config/db.php` file and update the database connection details:

```php
<?php
// Database connection parameters
define('DB_SERVER', 'localhost');
define('DB_USERNAME', 'root'); // Replace with your database username
define('DB_PASSWORD', ''); // Replace with your database password
define('DB_NAME', 'work_allocation_app');

// Attempt to connect to MySQL database
$link = mysqli_connect(DB_SERVER, DB_USERNAME, DB_PASSWORD, DB_NAME);

// Check connection
if($link === false){
    die("ERROR: Could not connect. " . mysqli_connect_error());
}
?>

**Important:** For production environments, it is highly recommended to use stronger credentials and secure your database.

### 4. Create an Admin User

After setting up the database, you'll need to manually insert an admin user into the `users` table. You can do this via phpMyAdmin or a MySQL client:
