<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Start the session
session_start();

// Check if the user is logged in, if not then redirect to login page
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: ../login.php");
    exit;
}

// Check if the user is an admin, if not then redirect to employee dashboard
if ($_SESSION["role"] !== "admin") {
    header("location: ../employee/dashboard.php");
    exit;
}

// Include config file
require_once "../config/db.php";


   function sendOtp($mobile,$deadline,$priority)
    {
		$newmobile = trim($mobile);
        $key = "bcd35428b5cd6672771b34c95b025f4c";
        $sender = "LBSSED";
		$messagTemp = "New Task Assigned, Deadline: $deadline Priority: $priority Regards,LBS GROUP";
        $message = urlencode ($messagTemp);
        $route = "1";
        $templateid = "1407175489350561798";
        $urltoCall = "https://sms.par-ken.com/api/smsapi?key=$key&route=$route&sender=$sender&number=$newmobile&sms=$message&templateid=$templateid";

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $urltoCall);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $smsResponse = curl_exec($ch);
        curl_close($ch);

	}


// Define variables and initialize with empty values
$title = $description = $assigned_to = $deadline = $priority = $attachment_path = "";
$title_err = $description_err = $assigned_to_err = $deadline_err = $priority_err = $attachment_err = "";

// Processing form data when form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    error_log("POST request received in assign_task.php");
    error_log("FILES array: " . print_r($_FILES, true));

    // Validate title
    if (empty(trim($_POST["title"]))) {
        $title_err = "Please enter a task title.";
    } else {
        $title = trim($_POST["title"]);
    }

    // Validate description
    $description = trim($_POST["description"]);

    // Validate assigned_to
    if (empty(trim($_POST["assigned_to"]))) {
        $assigned_to_err = "Please select an employee.";
    } else {
        $assigned_to = trim($_POST["assigned_to"]);
    }

    // Validate deadline
    if (empty(trim($_POST["deadline"]))) {
        $deadline_err = "Please enter a deadline.";
    } else {
        $deadline = trim($_POST["deadline"]);
    }

    // Validate priority
    if (empty(trim($_POST["priority"]))) {
        $priority_err = "Please select a priority.";
    } else {
        $priority = trim($_POST["priority"]);
    }

    // Check input errors before inserting in database
    if (empty($title_err) && empty($assigned_to_err) && empty($deadline_err) && empty($priority_err) && empty($attachment_err)) {
        // Handle file upload
        if (isset($_FILES["attachment"]) && $_FILES["attachment"]["error"] == 0) {
            $allowed_types = ['application/pdf'];
            $max_size = 2 * 1024 * 1024; // 2 MB

            $file_type = $_FILES["attachment"]["type"];
            $file_size = $_FILES["attachment"]["size"];
            $file_ext = strtolower(pathinfo($_FILES["attachment"]["name"], PATHINFO_EXTENSION));

            if (!in_array($file_type, $allowed_types) && $file_ext != 'pdf') {
                $attachment_err = "Only PDF files are allowed.";
            } elseif ($file_size > $max_size) {
                $attachment_err = "File size must be less than 2MB.";
            } else {
                $upload_dir = "uploads/tasks/";
                if (!is_dir($upload_dir)) {
                    mkdir($upload_dir, 0777, true);
                }
                $file_name = uniqid() . "_" . basename($_FILES["attachment"]["name"]);
                $target_file = $upload_dir . $file_name;

                if (move_uploaded_file($_FILES["attachment"]["tmp_name"], $target_file)) {
                    $attachment_path = $target_file;
                } else {
                    $attachment_err = "Error uploading file.";
                }
            }
        } else {
            error_log("Attachment error: " . $attachment_err);
        }

        // Only proceed with database insertion if there are no attachment errors
        if (empty($attachment_err)) {
            // Prepare an insert statement
            $sql = "INSERT INTO tasks (title, description, assigned_to, assigned_by, deadline, priority, attachment_path) VALUES (?, ?, ?, ?, ?, ?, ?)";

            if ($stmt = mysqli_prepare($link, $sql)) {
                // Bind variables to the prepared statement as parameters
                mysqli_stmt_bind_param($stmt, "ssiisss", $param_title, $param_description, $param_assigned_to, $param_assigned_by, $param_deadline, $param_priority, $param_attachment_path);

                // Set parameters
                $param_title = $title;
                $param_description = $description;
                $param_assigned_to = $assigned_to;
                $param_assigned_by = $_SESSION["id"]; // Admin's user_id
                $param_deadline = $deadline;
                $param_priority = $priority;
                $param_attachment_path = $attachment_path;

            // Attempt to execute the prepared statement
            if (mysqli_stmt_execute($stmt)) {
                // Get the contact number of the assigned employee
                $sql_get_contact = "SELECT contact_number FROM users WHERE user_id = ?";
                if ($stmt_get_contact = mysqli_prepare($link, $sql_get_contact)) {
                    mysqli_stmt_bind_param($stmt_get_contact, "i", $param_assigned_to);
                    $param_assigned_to = $assigned_to;
                    if (mysqli_stmt_execute($stmt_get_contact)) {
                        mysqli_stmt_store_result($stmt_get_contact);
                        if (mysqli_stmt_num_rows($stmt_get_contact) == 1) {
                            mysqli_stmt_bind_result($stmt_get_contact, $employee_contact_number);
                            mysqli_stmt_fetch($stmt_get_contact);

                            // Simulate sending SMS
                            $sms_message = "New Task Assigned: " . $title . " (Deadline: " . $deadline . ", Priority: " . $priority . "). Description: " . $description;
                            
                            sendOtp($employee_contact_number,$deadline,$priority);
                            // In a real application, you would integrate with an SMS gateway here.
                            // For demonstration, we'll just log it or echo a message.
                            // For example: send_sms($employee_contact_number, $sms_message);
                            // error_log("SMS sent to " . $employee_contact_number . ": " . $sms_message);
                            // You might want to add a success message to the user here
                        }
                    }
                    mysqli_stmt_close($stmt_get_contact);
                }

                // Redirect to task management page
                header("location: manage_tasks.php");
                exit();
            } else {
                echo "Something went wrong. Please try again later.";
            }

            // Close statement
            mysqli_stmt_close($stmt);
        }
    }

    } // Closing brace for if (empty($title_err) && empty($assigned_to_err) && empty($deadline_err) && empty($priority_err) && empty($attachment_err))

    // Close connection
    mysqli_close($link);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Assign Task</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f7f6;
            color: #333;
        }
        .wrapper {
            display: flex;
            min-height: 100vh;
            transition: all 0.3s ease;
        }
        .sidebar {
            /* width: 250px; */
            background-color: #2c3e50;
            color: #ecf0f1;
            padding: 20px;
            box-shadow: 2px 0 5px rgba(0,0,0,0.1);
            display: flex;
            flex-direction: column;
            transition: all 0.3s ease;
          
        }
        .sidebar h3 {
            text-align: center;
            margin-bottom: 30px;
            color: #ecf0f1;
        }
        .sidebar ul {
            list-style: none;
            padding: 0;
            flex-grow: 1;
        }
        .sidebar ul li {
            margin-bottom: 15px;
        }
        .sidebar ul li a {
            color: #ecf0f1;
            text-decoration: none;
            padding: 10px 15px;
            display: block;
            border-radius: 5px;
            transition: background-color 0.3s ease;
        }
        .sidebar ul li a:hover,
        .sidebar ul li a.active {
            background-color: #34495e;
        }
        .main-content {
            flex-grow: 1;
            padding: 30px;
            transition: all 0.3s ease;
        }
        .navbar {
            background-color: #ffffff;
            padding: 15px 30px;
            border-bottom: 1px solid #ddd;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        .navbar h2 {
            margin: 0;
            color: #333;
        }
        .navbar .profile-info {
            display: flex;
            align-items: center;
        }
        .navbar .profile-info .username {
            margin-right: 15px;
            font-weight: bold;
            color: #555;
        }
        .navbar .btn-logout {
            background-color: #e74c3c;
            color: #fff;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            text-decoration: none;
            transition: background-color 0.3s ease;
        }
        .navbar .btn-logout:hover {
            background-color: #c0392b;
        }
        .card {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            margin-bottom: 30px;
            padding: 20px;
        }
        .card-header {
            font-size: 1.5rem;
            margin-bottom: 20px;
            color: #2c3e50;
            border-bottom: 1px solid #eee;
            padding-bottom: 10px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        .form-control {
            width: 100%;
            padding: 10px;
            border: 1px solid #ced4da;
            border-radius: 4px;
            box-sizing: border-box;
        }
        .btn-primary {
            background-color: #007bff;
            border-color: #007bff;
            color: #fff;
            padding: 10px 15px;
            border-radius: 4px;
            cursor: pointer;
        }
        .btn-primary:hover {
            background-color: #0056b3;
            border-color: #0056b3;
        }
        .btn-secondary {
            background-color: #6c757d;
            border-color: #6c757d;
            color: #fff;
            padding: 10px 15px;
            border-radius: 4px;
            cursor: pointer;
            margin-left: 10px;
        }
        .btn-secondary:hover {
            background-color: #5a6268;
            border-color: #545b62;
        }
        .help-block {
            color: #dc3545;
            font-size: 0.875em;
            margin-top: 5px;
        }

        /* Responsive styles */
        @media (max-width: 768px) {
            .wrapper {
                flex-direction: column;
            }
            .sidebar {
                /* width: 100%; */
                height: auto;
                padding: 15px;
                /* position: relative; */
                box-shadow: none;
                    position: fixed;
                    top: 0;
                    left: 0;
                    width: 100%;
                    z-index: 999; 
            }
            .sidebar ul {
                display: none; /* Hidden by default */
                flex-direction: column;
            }
            .sidebar.active ul {
                display: flex; /* Show when active */
            }
            .sidebar .sidebar-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
            }
            .sidebar .sidebar-header h3 {
                margin-bottom: 0;
            }
            .main-content {
                padding: 15px;
            }
            .navbar {
                flex-direction: column;
                align-items: flex-start;
                padding: 15px;
            }
            .navbar h2 {
                margin-bottom: 10px;
            }
            .navbar .profile-info {
                margin-top: 10px;
                width: 100%;
                justify-content: space-between;
            }
            .navbar .profile-info .username {
                margin-right: 0;
            }
        }
    </style>
</head>
<body>
    <div class="wrapper" id="wrapper">
        <nav class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <h3>Work Allocation</h3>
                <button type="button" id="sidebarCollapse" class="btn btn-dark d-md-none">
                    <i class="bi bi-list"></i>
                </button>
            </div>
            <ul>
                <li><a href="dashboard.php"><i class="bi bi-grid-fill"></i> Dashboard</a></li>
                <li><a href="manage_employees.php"><i class="bi bi-people-fill"></i> Manage Employees</a></li>
                <li><a href="manage_tasks.php" class="active"><i class="bi bi-list-task"></i> Manage Tasks</a></li>
                <li><a href="../logout.php"><i class="bi bi-box-arrow-right"></i> Logout</a></li>
            </ul>
        </nav>

        <div class="main-content">
            <br>
            <header class="navbar mt-5" >
                <h2>Assign New Task</h2>
                <div class="profile-info">
                    <span class="username">Welcome, <?php echo htmlspecialchars($_SESSION["username"]); ?></span>
                    <a href="../logout.php" class="btn-logout">Logout</a>
                </div>
            </header>

            <div class="container-fluid mt-4">
                <div class="card">
                    <div class="card-header">Assign New Task</div>
                    <div class="card-body">
                        <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post" enctype="multipart/form-data">
                            <div class="form-group">
                                <label>Task Title</label>
                                <input type="text" name="title" class="form-control <?php echo (!empty($title_err)) ? 'is-invalid' : ''; ?>" value="<?php echo $title; ?>">
                                <span class="help-block"><?php echo $title_err; ?></span>
                            </div>
                            <div class="form-group">
                                <label>Description</label>
                                <textarea name="description" class="form-control <?php echo (!empty($description_err)) ? 'is-invalid' : ''; ?>" rows="5"><?php echo $description; ?></textarea>
                                <span class="help-block"><?php echo $description_err; ?></span>
                            </div>
                            <div class="form-group">
                                <label>Assigned To</label>
                                <select name="assigned_to" class="form-control <?php echo (!empty($assigned_to_err)) ? 'is-invalid' : ''; ?>">
                                    <option value="">Select Employee</option>
                                    <?php
                                    // Fetch employees from the database
                                    $sql_employees = "SELECT user_id, username FROM users WHERE role = 'employee'";
                                    $result_employees = mysqli_query($link, $sql_employees);
                                    if (mysqli_num_rows($result_employees) > 0) {
                                        while ($row_employee = mysqli_fetch_assoc($result_employees)) {
                                            echo '<option value="' . $row_employee['user_id'] . '"' . (($assigned_to == $row_employee['user_id']) ? 'selected' : '') . '>' . htmlspecialchars($row_employee['username']) . '</option>';
                                        }
                                    }
                                    ?>
                                </select>
                                <span class="help-block"><?php echo $assigned_to_err; ?></span>
                            </div>
                            <div class="form-group">
                                <label>Deadline</label>
                                <input type="date" name="deadline" class="form-control <?php echo (!empty($deadline_err)) ? 'is-invalid' : ''; ?>" value="<?php echo $deadline; ?>">
                                <span class="help-block"><?php echo $deadline_err; ?></span>
                            </div>
                            <div class="form-group">
                                <label>Priority</label>
                                <select name="priority" class="form-control <?php echo (!empty($priority_err)) ? 'is-invalid' : ''; ?>">
                                    <option value="">Select Priority</option>
                                    <option value="low" <?php echo ($priority == 'low') ? 'selected' : ''; ?>>Low</option>
                                    <option value="medium" <?php echo ($priority == 'medium') ? 'selected' : ''; ?>>Medium</option>
                                    <option value="high" <?php echo ($priority == 'high') ? 'selected' : ''; ?>>High</option>
                                </select>
                                <span class="help-block"><?php echo $priority_err; ?></span>
                            </div>
                            <div class="form-group">
                                <label>Attach File (PDF, max 2MB)</label>
                                <input type="file" name="attachment" id="attachment" class="form-control">
                                <span class="help-block"></span>
                            </div>
                            <div class="form-group">
                                <input type="submit" class="btn btn-primary" value="Assign Task">
                                <a href="manage_tasks.php" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Sidebar toggle for mobile
        document.getElementById('sidebarCollapse').addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('active');
        });
    </script>
</body>
</html>