<?php
// Start the session
session_start();
// Check if the user is logged in, if not then redirect to login page
if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true) {
    header("location: ../login.php");
    exit;
}
// Check if the user is an admin, if not then redirect to employee dashboard
if ($_SESSION["role"] !== "admin") {
    header("location: ../employee/dashboard.php");
    exit;
}
// Include config file
require_once "../config/db.php";

// Fetch total employees
$total_employees = 0;
$sql_total_employees = "SELECT COUNT(*) AS total FROM users WHERE role = 'employee'";
if ($result_total_employees = mysqli_query($link, $sql_total_employees)) {
    $row = mysqli_fetch_assoc($result_total_employees);
    $total_employees = $row['total'];
    mysqli_free_result($result_total_employees);
}

// Fetch total pending tasks
$total_pending_tasks = 0;
$sql_pending_tasks = "SELECT COUNT(*) AS total FROM tasks WHERE status = 'pending'";
if ($result_pending_tasks = mysqli_query($link, $sql_pending_tasks)) {
    $row = mysqli_fetch_assoc($result_pending_tasks);
    $total_pending_tasks = $row['total'];
    mysqli_free_result($result_pending_tasks);
}

// Fetch total completed tasks
$total_completed_tasks = 0;
$sql_completed_tasks = "SELECT COUNT(*) AS total FROM tasks WHERE status = 'completed'";
if ($result_completed_tasks = mysqli_query($link, $sql_completed_tasks)) {
    $row = mysqli_fetch_assoc($result_completed_tasks);
    $total_completed_tasks = $row['total'];
    mysqli_free_result($result_completed_tasks);
}

// Close connection
mysqli_close($link);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f4f7f6;
            color: #333;
        }
        .wrapper {
            display: flex;
            min-height: 100vh;
            transition: all 0.3s ease;
            
        }
        .sidebar {
            width: 250px;
            background-color: #2c3e50;
            color: #ecf0f1;
            padding: 20px;
            box-shadow: 2px 0 5px rgba(0,0,0,0.1);
            display: flex;
            flex-direction: column;
            transition: all 0.3s ease;
        }
        .sidebar h3 {
            text-align: center;
            margin-bottom: 30px;
            color: #ecf0f1;
        }
        .sidebar ul {
            list-style: none;
            padding: 0;
            flex-grow: 1;
        }
        .sidebar ul li {
            margin-bottom: 15px;
        }
        .sidebar ul li a {
            color: #ecf0f1;
            text-decoration: none;
            padding: 10px 15px;
            display: block;
            border-radius: 5px;
            transition: background-color 0.3s ease;
        }
        .sidebar ul li a:hover,
        .sidebar ul li a.active {
            background-color: #34495e;
        }
        .main-content {
            flex-grow: 1;
            padding: 30px;
            transition: all 0.3s ease;
        }
        .navbar {
            background-color: #ffffff;
            padding: 15px 30px;
            border-bottom: 1px solid #ddd;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        .navbar h2 {
            margin: 0;
            color: #333;
        }
        .navbar .profile-info {
            display: flex;
            align-items: center;
        }
        .navbar .profile-info .username {
            margin-right: 15px;
            font-weight: bold;
            color: #555;
        }
        .navbar .btn-logout {
            background-color: #e74c3c;
            color: #fff;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            text-decoration: none;
            transition: background-color 0.3s ease;
        }
        .navbar .btn-logout:hover {
            background-color: #c0392b;
        }
        .card {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.08);
            margin-bottom: 30px;
            padding: 20px;
        }
        .card-header {
            font-size: 1.5rem;
            margin-bottom: 20px;
            color: #2c3e50;
            border-bottom: 1px solid #eee;
            padding-bottom: 10px;
        }
        .table-responsive {
            margin-top: 20px;
            overflow-x: auto; /* Ensure tables are horizontally scrollable */
        }
        .table {
            width: 100%;
            margin-bottom: 1rem;
            color: #212529;
            border-collapse: collapse;
        }
        .table th,
        .table td {
            padding: 0.75rem;
            vertical-align: top;
            border-top: 1px solid #dee2e6;
        }
        .table thead th {
            vertical-align: bottom;
            border-bottom: 2px solid #dee2e6;
        }
        .table tbody + tbody {
            border-top: 2px solid #dee2e6;
        }
        .table-striped tbody tr:nth-of-type(odd) {
            background-color: rgba(0, 0, 0, 0.05);
        }
        .btn-action {
            margin-right: 5px;
        }
        .btn-add {
            background-color: #28a745;
            color: #fff;
            border: none;
            padding: 8px 15px;
            border-radius: 5px;
            text-decoration: none;
            transition: background-color 0.3s ease;
        }
        .btn-add:hover {
            background-color: #218838;
        }
        .modal-content {
            border-radius: 8px;
        }
        .modal-header {
            border-bottom: none;
            padding-bottom: 0;
        }
        .modal-footer {
            border-top: none;
            padding-top: 0;
        }

        /* Responsive styles */
        @media (max-width: 768px) {
            .wrapper {
                flex-direction: column;
            }
            .sidebar {
                /* width: 100%; */
                height: auto;
                padding: 15px;
                /* position: relative; */
                box-shadow: none;
                    position: fixed;
                    top: 0;
                    left: 0;
                    width: 100%;
                    z-index: 999; 
                
            }
            .sidebar ul {
                display: none; /* Hidden by default */
                flex-direction: column;
            }
            .sidebar.active ul {
                display: flex; /* Show when active */
            }
            .sidebar .sidebar-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
            }
            .sidebar .sidebar-header h3 {
                margin-bottom: 0;
            }
            .main-content {
                padding: 15px;
            }
            .navbar {
                flex-direction: column;
                align-items: flex-start;
                padding: 15px;
            }
            .navbar h2 {
                margin-bottom: 10px;
            }
            .navbar .profile-info {
                margin-top: 10px;
                width: 100%;
                justify-content: space-between;
            }
            .navbar .profile-info .username {
                margin-right: 0;
            }
        }
    </style>
</head>
<body>
    <div class="wrapper" id="wrapper" style="">
        <nav class="sidebar" id="sidebar" >
            <div class="sidebar-header">
                <h3>Work Allocation</h3>
                <button type="button" id="sidebarCollapse" class="btn btn-dark d-md-none">
                    <i class="bi bi-list"></i>
                </button>
            </div>
            <ul>
                <li><a href="dashboard.php" class="active"><i class="bi bi-grid-fill"></i> Dashboard</a></li>
                <li><a href="manage_employees.php"><i class="bi bi-people-fill"></i> Manage Employees</a></li>
                <li><a href="manage_tasks.php"><i class="bi bi-list-task"></i> Manage Tasks</a></li>
                <li><a href="login_history.php"><i class="bi bi-clock-history"></i> Login History</a></li>
                <li><a href="../logout.php"><i class="bi bi-box-arrow-right"></i> Logout</a></li>
            </ul>
        </nav>
        <div class="main-content">
            <br>
            <header class="navbar mt-5">
                <h2>Admin Dashboard</h2>
                <div class="profile-info">
                    <span class="username">Welcome, <?php echo htmlspecialchars($_SESSION["username"]); ?></span>
                    <a href="../logout.php" class="btn-logout">Logout</a>
                </div>
            </header>
            <div class="container-fluid mt-4">
                <div class="row">
                    <div class="col-md-4">
                        <div class="card text-white bg-primary mb-3">
                            <div class="card-header">Total Employees</div>
                            <div class="card-body">
                                <h5 class="card-title"><?php echo $total_employees; ?></h5>
                                <p class="card-text">Number of registered employees.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card text-white bg-warning mb-3">
                            <div class="card-header">Pending Tasks</div>
                            <div class="card-body">
                                <h5 class="card-title"><?php echo $total_pending_tasks; ?></h5>
                                <p class="card-text">Tasks awaiting completion.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card text-white bg-success mb-3">
                            <div class="card-header">Completed Tasks</div>
                            <div class="card-body">
                                <h5 class="card-title"><?php echo $total_completed_tasks; ?></h5>
                                <p class="card-text">Tasks successfully finished.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        // Initialize tooltips
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        });
 
        // SweetAlert for delete confirmation
        document.querySelectorAll('.btn-danger').forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                const url = this.href;
                Swal.fire({
                    title: 'Are you sure?',
                    text: "You won't be able to revert this!",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        window.location.href = url;
                    }
                })
            });
        });
 
        // Sidebar toggle for mobile
        document.getElementById('sidebarCollapse').addEventListener('click', function() {
            document.getElementById('sidebar').classList.toggle('active');
        });
    </script>
</body>
</html>
