<?php
// Start the session
session_start();

// Include config file
require_once "../config/db.php";

header('Content-Type: application/json');

$response = ['success' => false, 'message' => ''];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $task_id = filter_input(INPUT_POST, 'task_id', FILTER_VALIDATE_INT);
    $user_id = filter_input(INPUT_POST, 'user_id', FILTER_VALIDATE_INT);
    $comment_text = trim($_POST["comment_text"]);

    // Basic validation
    if (!$task_id || !$user_id || empty($comment_text)) {
        $response['message'] = "Invalid input. Please provide task ID, user ID, and comment text.";
        echo json_encode($response);
        exit;
    }

    // Check if user is logged in and matches the provided user_id
    if (!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] !== true || $_SESSION["id"] != $user_id) {
        $response['message'] = "Unauthorized access.";
        echo json_encode($response);
        exit;
    }

    // Prepare an insert statement
    $sql = "INSERT INTO comments (task_id, user_id, comment_text) VALUES (?, ?, ?)";

    if ($stmt = mysqli_prepare($link, $sql)) {
        // Bind variables to the prepared statement as parameters
        mysqli_stmt_bind_param($stmt, "iis", $param_task_id, $param_user_id, $param_comment_text);

        // Set parameters
        $param_task_id = $task_id;
        $param_user_id = $user_id;
        $param_comment_text = $comment_text;

        // Attempt to execute the prepared statement
        if (mysqli_stmt_execute($stmt)) {
            $response['success'] = true;
            $response['message'] = "Comment added successfully.";
            $response['username'] = htmlspecialchars($_SESSION['username']);
            $response['created_at'] = date('Y-m-d H:i:s'); // Current timestamp
            $response['comment_text'] = htmlspecialchars($comment_text);
        } else {
            $response['message'] = "Error: Could not execute query. " . mysqli_error($link);
        }

        // Close statement
        mysqli_stmt_close($stmt);
    } else {
        $response['message'] = "Error: Could not prepare query. " . mysqli_error($link);
    }

    // Close connection
    mysqli_close($link);
} else {
    $response['message'] = "Invalid request method.";
}

echo json_encode($response);
?>