<?php session_start();
// Include config file
require_once "config/db.php";

// Start session


// Check if the user is already logged in, if yes then redirect to dashboard
if(isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true){
    if ($_SESSION["role"] == "admin") {
        header("location: admin/dashboard.php");
    } else {
        header("location: employee/dashboard.php");
    }
    exit;
}
// Define variables and initialize with empty values
$username = $password = "";
$username_err = $password_err = $login_err = "";
// Processing form data when form is submitted
if($_SERVER["REQUEST_METHOD"] == "POST"){

    // Check if username is empty
    if(empty(trim($_POST["username"])) && isset($_POST["username"])){
        $username_err = "Please enter username.";
    } else if (isset($_POST["username"])){
        $username = trim($_POST["username"]);
    }

    // Check if password is empty
    if(empty(trim($_POST["password"])) && isset($_POST["password"])){
        $password_err = "Please enter your password.";
    } else if (isset($_POST["password"])){
        $password = trim($_POST["password"]);
    }

    // Validate credentials
    if(empty($username_err) && empty($password_err)){
        // Prepare a select statement
        $sql = "SELECT user_id, username, password, role FROM users WHERE username = ?";

        if($stmt = mysqli_prepare($link, $sql)){
            // Bind variables to the prepared statement as parameters
            mysqli_stmt_bind_param($stmt, "s", $param_username);

            // Set parameters
            $param_username = $username;

            // Attempt to execute the prepared statement
            if(mysqli_stmt_execute($stmt)){
                // Store result
                mysqli_stmt_store_result($stmt);

                // Check if username exists, if yes then verify password
                if(mysqli_stmt_num_rows($stmt) == 1){
                    // Bind result variables
                    mysqli_stmt_bind_result($stmt, $id, $username, $hashed_password, $role);
                    if(mysqli_stmt_fetch($stmt)){
                        if(password_verify($password, $hashed_password)){
                            // Password is correct, start a new session

                            // Store data in session variables
                            $_SESSION["loggedin"] = true;
                            $_SESSION["id"] = $id;
                            $_SESSION["username"] = $username;
                            $_SESSION["role"] = $role;

                            // Record login history
                            $insert_login_sql = "INSERT INTO user_logins (user_id, ip_address, status) VALUES (?, ?, 'login')";
                            if ($insert_stmt = mysqli_prepare($link, $insert_login_sql)) {
                                mysqli_stmt_bind_param($insert_stmt, "is", $param_user_id, $param_ip_address);
                                $param_user_id = $id;
                                $param_ip_address = $_SERVER['REMOTE_ADDR'];
                                mysqli_stmt_execute($insert_stmt);
                                mysqli_stmt_close($insert_stmt);
                            }

                            // Redirect user to appropriate dashboard page
                            if ($role == "admin") {
                                header("location: admin/dashboard.php");
                            } else {
                                header("location: employee/dashboard.php");
                            }
                        } else{
                            // Password is not valid, display a generic error message
                            $login_err = "Invalid username or password.";
                        }
                    }
                } else{
                    // Username doesn't exist, display a generic error message
                    $login_err = "Invalid username or password.";
                }
            } else{
                echo "Oops! Something went wrong. Please try again later.";
            }
            // Close statement
            mysqli_stmt_close($stmt);
        }
    }
    // Close connection
    mysqli_close($link);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font: 14px sans-serif;
            background-color: #f8f9fa;
            padding: 15px; /* Add some padding for small screens */
        }
        .wrapper {
            max-width: 400px; /* Use max-width instead of fixed width */
            padding: 20px;
            margin: 50px auto;
            background-color: #ffffff;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        /* Media query for smaller screens */
        @media (max-width: 576px) {
            .wrapper {
                margin: 20px auto; /* Adjust margin for smaller screens */
                padding: 15px; /* Adjust padding for smaller screens */
            }
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        .form-control {
            width: 100%;
            padding: 10px;
            border: 1px solid #ced4da;
            border-radius: 4px;
            box-sizing: border-box;
        }
        .btn-primary {
            background-color: #007bff;
            border-color: #007bff;
            color: #fff;
            padding: 10px 15px;
            border-radius: 4px;
            cursor: pointer;
            width: 100%;
        }
        .btn-primary:hover {
            background-color: #0056b3;
            border-color: #0056b3;
        }
        .help-block {
            color: #dc3545;
            font-size: 0.875em;
            margin-top: 5px;
        }
        .text-center {
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-5">
                <div class="wrapper" id="login-form">
                   <div class="text-center"><img src="./image/logo.png" class="img-fluid" alt="logo"></div>
                    <h2 class="text-center"></h2>
                    <p class="text-center">Please fill in your credentials to login.</p>

                    <?php
                    if(!empty($login_err)){
                        echo '<div class="alert alert-danger">' . $login_err . '</div>';
                    }
                    ?>
                    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
                        <div class="form-group">
                            <label>Username</label>
                            <input type="text" name="username" class="form-control <?php echo (!empty($username_err)) ? 'is-invalid' : ''; ?>" value="<?php echo $username; ?>">
                            <span class="help-block"><?php echo $username_err; ?></span>
                        </div>
                        <div class="form-group">
                            <label>Password</label>
                            <input type="password" name="password" class="form-control <?php echo (!empty($password_err)) ? 'is-invalid' : ''; ?>">
                            <span class="help-block"><?php echo $password_err; ?></span>
                        </div>
                        <div class="form-group">
                            <input type="submit" class="btn btn-primary" value="Login">
                        </div>
                        <!-- <p class="text-center">Don't have an account? <a href="#" id="show-register">Sign up now</a>.</p> -->
                    </form>
                </div>

                <div class="wrapper" id="register-form" style="display: none;">
                    <h2 class="text-center">Admin Registration</h2>
                    <p class="text-center">Please fill this form to register an admin account.</p>
                    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
                        <div class="form-group">
                            <label>Username</label>
                            <input type="text" name="reg_username" class="form-control" value="">
                            <span class="help-block"></span>
                        </div>
                        <div class="form-group">
                            <label>Password</label>
                            <input type="password" name="reg_password" class="form-control">
                            <span class="help-block"></span>
                        </div>
                        <div class="form-group">
                            <label>Confirm Password</label>
                            <input type="password" name="reg_confirm_password" class="form-control">
                            <span class="help-block"></span>
                        </div>
                        <div class="form-group">
                            <input type="hidden" name="role" value="admin">
                            <input type="submit" class="btn btn-primary" value="Register Admin">
                        </div>
                        <p class="text-center">Already have an account? <a href="#" id="show-login">Login here</a>.</p>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.getElementById('show-register').addEventListener('click', function(e) {
            e.preventDefault();
            document.getElementById('login-form').style.display = 'none';
            document.getElementById('register-form').style.display = 'block';
        });

        document.getElementById('show-login').addEventListener('click', function(e) {
            e.preventDefault();
            document.getElementById('login-form').style.display = 'block';
            document.getElementById('register-form').style.display = 'none';
        });
    </script>
</body>
</html>