<?php
// Initialize the session
session_start();

// Include config file
require_once "config/db.php";

// Record logout history if user was logged in
if (isset($_SESSION["loggedin"]) && $_SESSION["loggedin"] === true) {
    $user_id = $_SESSION["id"];
    $ip_address = $_SERVER['REMOTE_ADDR'];

    $insert_logout_sql = "INSERT INTO user_logins (user_id, ip_address, status) VALUES (?, ?, 'logout')";
    if ($insert_stmt = mysqli_prepare($link, $insert_logout_sql)) {
        mysqli_stmt_bind_param($insert_stmt, "is", $user_id, $ip_address);
        mysqli_stmt_execute($insert_stmt);
        mysqli_stmt_close($insert_stmt);
    }
    mysqli_close($link);
}

// Unset all of the session variables
$_SESSION = array();

// Destroy the session.
session_destroy();

// Redirect to login page
header("location: login.php");
exit;
?>